/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.rss.reader.runner;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class UnrestrictedRssReaderManagementRootGenerator
extends UnrestrictedSessionRunner {
    private static Log log = LogFactory.getLog(UnrestrictedRssReaderManagementRootGenerator.class);
    protected boolean isACPNeeded = true;
    protected String containerPath;

    public UnrestrictedRssReaderManagementRootGenerator(CoreSession session, String containerPath) {
        super(session);
        this.containerPath = containerPath;
    }

    public void run() throws ClientException {
        if (!this.session.exists((DocumentRef)new PathRef(this.containerPath + "rssFeeds"))) {
            DocumentModel doc = this.session.createDocumentModel(this.containerPath, "rssFeeds", "RssFeedRoot");
            doc.setPropertyValue("dc:title", (Serializable)((Object)"Rss Feed Models"));
            doc = this.session.createDocument(doc);
            this.setACP(doc);
            this.session.save();
        }
    }

    public UnrestrictedRssReaderManagementRootGenerator willSetRightsForAdminitrators(boolean addACP) {
        this.isACPNeeded = addACP;
        return this;
    }

    protected void setACP(DocumentModel doc) throws ClientException {
        if (!this.isACPNeeded) {
            return;
        }
        ACL acl = doc.getACP().getOrCreateACL();
        try {
            for (String administratorGroup : this.getUserManager().getAdministratorsGroups()) {
                ACE ace = new ACE(administratorGroup, "Everything", true);
                acl.add((Object)ace);
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot set default ACE on " + this.containerPath), (Throwable)e);
        }
        ACE ace = new ACE("Everyone", "Read", true);
        acl.add((Object)ace);
        this.session.setACP(doc.getRef(), doc.getACP(), true);
        this.session.save();
    }

    protected UserManager getUserManager() throws Exception {
        return (UserManager)Framework.getService(UserManager.class);
    }
}

