/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.rss.reader.manager.seam;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.contentbrowser.DocumentActions;
import org.nuxeo.ecm.webapp.helpers.EventManager;
import org.nuxeo.rss.reader.service.RSSFeedService;

@Name(value="rssFeedActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class RssFeedActions
extends InputController
implements Serializable {
    private static final long serialVersionUID = 8882417548656036277L;
    protected static final Log log = LogFactory.getLog(RssFeedActions.class);
    @In(create=true)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient DocumentActions documentActions;
    @In(create=true)
    protected transient UserManager userManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient RSSFeedService rssFeed;
    protected DocumentModel currentDocument = null;
    protected boolean showForm = false;

    public DocumentModel getBareFeedReaderModel() throws ClientException {
        return this.documentManager.createDocumentModel("RssFeed");
    }

    public DocumentModel getCurrentDocument() throws ClientException {
        if (this.currentDocument == null) {
            this.currentDocument = this.getBareFeedReaderModel();
        }
        return this.currentDocument;
    }

    public void saveDocument() throws ClientException {
        this.rssFeed.getRssReaderManagementContainer(this.documentManager);
        if (this.currentDocument.getId() == null) {
            this.documentActions.saveDocument(this.currentDocument);
            EventManager.raiseEventsOnDocumentChange((DocumentModel)this.currentDocument);
        } else {
            Events.instance().raiseEvent("beforeDocumentChanged", new Object[]{this.currentDocument});
            this.currentDocument = this.documentManager.saveDocument(this.currentDocument);
            this.documentManager.save();
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("document_modified"), new Object[]{this.resourcesAccessor.getMessages().get(this.currentDocument.getType())});
            EventManager.raiseEventsOnDocumentChange((DocumentModel)this.currentDocument);
        }
        this.resetDocument();
        this.toggleForm();
    }

    public void setCurrentDocument(String path) throws ClientException {
        if (path != null && !"".equals(path)) {
            PathRef ref = new PathRef(path);
            if (this.documentManager.exists((DocumentRef)ref)) {
                this.currentDocument = this.documentManager.getDocument((DocumentRef)new PathRef(path));
            } else {
                this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.resourcesAccessor.getMessages().get("Error.Document.Not.Found"), new Object[0]);
            }
        }
    }

    protected void resetDocument() {
        this.currentDocument = null;
    }

    public boolean isShowForm() {
        return this.showForm;
    }

    public boolean isShowCreateForm() {
        return this.isShowForm() && this.currentDocument != null && this.currentDocument.getId() == null;
    }

    public boolean isShowEditForm() {
        return this.isShowForm() && this.currentDocument != null && this.currentDocument.getId() != null;
    }

    public void toggleForm() {
        this.showForm = !this.showForm;
    }

    public void toggleAndReset() {
        this.toggleForm();
        this.resetDocument();
    }

    public String getLink(String link) {
        block2: {
            try {
                this.navigationContext.setCurrentDocument(this.rssFeed.getRssReaderManagementContainer(this.documentManager));
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)String.format("Unable to set the current document to \"%s\"", "/management/rssFeeds"));
            }
        }
        return link;
    }
}

