/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.standalone;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.nuxeo.common.Environment;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.standalone.StandaloneUpdateService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RuntimeFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={RuntimeFeature.class})
public abstract class PackageTestCase {
    protected static final Log log = LogFactory.getLog(PackageTestCase.class);
    public static final String TEST_PACKAGES_PREFIX = "packages/";
    protected PackageUpdateService service;

    @Before
    public void setUp() throws Exception {
        this.setupService();
    }

    @After
    public void tearDown() throws Exception {
        if (this.service instanceof StandaloneUpdateService) {
            this.tearDownStandaloneUpdateService();
        }
    }

    protected File getTestPackageZip(String name) throws IOException, URISyntaxException {
        File zip = Framework.createTempFile((String)("nuxeo-" + name + "-"), (String)".zip");
        Framework.trackFile((File)zip, (Object)zip);
        URI uri = this.getResource(TEST_PACKAGES_PREFIX + name).toURI();
        if (uri.getScheme().equals("jar")) {
            String part = uri.getSchemeSpecificPart();
            String basePath = part.substring(part.lastIndexOf("!") + 1);
            try (FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                this.createZip(zip, fs.getPath(basePath, new String[0]));
            }
        } else {
            this.createZip(zip, new File(uri).toPath());
        }
        return zip;
    }

    protected URL getResource(String name) {
        return this.getClass().getClassLoader().getResource(name);
    }

    protected void createZip(File zip, final Path basePath) throws IOException {
        try (final ZipOutputStream zout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zip)));){
            Files.walkFileTree(basePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    if (attrs.isDirectory()) {
                        return FileVisitResult.CONTINUE;
                    }
                    String rel = basePath.relativize(path).toString();
                    if (rel.startsWith(".")) {
                        return FileVisitResult.CONTINUE;
                    }
                    zout.putNextEntry(new ZipEntry(rel));
                    try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                        IOUtils.copy((InputStream)in, (OutputStream)zout);
                    }
                    zout.closeEntry();
                    return FileVisitResult.CONTINUE;
                }
            });
            zout.flush();
        }
    }

    protected void setupService() throws IOException, PackageException {
        File tmpHome = Framework.createTempFile((String)"tmphome", null);
        Framework.trackFile((File)tmpHome, (Object)tmpHome);
        FileUtils.forceDelete((File)tmpHome);
        tmpHome.mkdirs();
        Environment env = new Environment(tmpHome);
        Environment.setDefault((Environment)env);
        env.setServerHome(tmpHome);
        env.init();
        this.service = new StandaloneUpdateService(env);
        this.service.initialize();
        File storeDir = ((StandaloneUpdateService)this.service).getPersistence().getStore();
        File junkPackageFile = File.createTempFile("junk", null, storeDir);
        junkPackageFile.deleteOnExit();
    }

    protected void tearDownStandaloneUpdateService() {
        FileUtils.deleteQuietly((File)Environment.getDefault().getHome());
    }
}

