/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.standalone.commands;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.nuxeo.common.Environment;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.standalone.commands.AbstractCommandTest;
import org.nuxeo.connect.update.task.Task;

public class TestUpdateGuard
extends AbstractCommandTest {
    private File oldJar;
    private File expectedJar;
    private File unexpectedJar;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        File bundles = new File(Environment.getDefault().getHome(), "bundles");
        this.oldJar = new File(bundles, "foo-abc-1.0.jar");
        FileUtils.writeStringToFile((File)this.oldJar, (String)"old JAR content", (Charset)StandardCharsets.UTF_8);
        this.expectedJar = new File(bundles, "foo-abc-1.1.jar");
        this.unexpectedJar = new File(bundles, "bar-def-2.0.jar");
        File abc = this.getTestPackageZip("test-abc");
        LocalPackage pkg = this.service.addPackage(abc);
        this.service.setPackageState(pkg, PackageState.STARTED);
    }

    @Override
    protected File createPackage() throws IOException, URISyntaxException {
        return this.getTestPackageZip("test-update-guard");
    }

    @Override
    protected void installDone(Task task, Throwable error) throws Exception {
        super.installDone(task, error);
        Assert.assertFalse((boolean)this.oldJar.exists());
        Assert.assertTrue((boolean)this.expectedJar.exists());
        Assert.assertFalse((boolean)this.unexpectedJar.exists());
    }

    @Override
    protected void uninstallDone(Task task, Throwable error) throws Exception {
        super.uninstallDone(task, error);
        Assert.assertTrue((boolean)this.oldJar.exists());
        Assert.assertFalse((boolean)this.expectedJar.exists());
        Assert.assertFalse((boolean)this.unexpectedJar.exists());
    }
}

