/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.standalone.registry;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.connect.update.PackageDef;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.standalone.registry.SharedFilesTest;
import org.nuxeo.connect.update.task.update.Entry;
import org.nuxeo.connect.update.task.update.UpdateManager;
import org.nuxeo.connect.update.xml.XmlWriter;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.LogCaptureFeature;

@Features(value={LogCaptureFeature.class})
public class TestRollback
extends SharedFilesTest {
    public static final String JARNAME = "some-jar";
    @Inject
    LogCaptureFeature.Result logCaptureResult;

    @Test
    public void testHotfixUninstall() throws Exception {
        String baseFilename = "some-jar-5.6.jar";
        FileUtils.writeStringToFile((File)new File(this.bundles, "some-jar-5.6.jar"), (String)"some-jar-5.6.jar", (Charset)StandardCharsets.UTF_8);
        UpdateManager mgr = this.getManager();
        Assert.assertEquals((long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles("some-jar-5.6.jar");
        File bak = new File(mgr.getBackupRoot(), "bundles");
        if (bak.isDirectory()) {
            Assert.assertEquals((long)0L, (long)bak.list().length);
        }
        HotFixPackage1 hotfix1 = new HotFixPackage1();
        hotfix1.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        Entry entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertTrue((String)"Should have a base version", (boolean)entry.hasBaseVersion());
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix1.getFileName());
        hotfix1.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles("some-jar-5.6.jar");
        hotfix1.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix1.getFileName());
        HotFixPackage2 hotfix2 = new HotFixPackage2();
        hotfix2.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)2L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix2.getFileName());
        hotfix2.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix1.getFileName());
        hotfix1.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles("some-jar-5.6.jar");
    }

    @Test
    @LogCaptureFeature.FilterWith(value=RegistryCorruptionLogFilter.class)
    public void testHotfixUninstallWithCorruptedRegistry() throws Exception {
        UpdateManager mgr = this.getManager();
        Assert.assertEquals((long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles(new String[0]);
        File bak = new File(mgr.getBackupRoot(), "bundles");
        if (bak.isDirectory()) {
            Assert.assertEquals((long)0L, (long)bak.list().length);
        }
        HotFixPackage1Corrupted hotfix1Corrupted = new HotFixPackage1Corrupted();
        hotfix1Corrupted.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        Entry entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertFalse((String)"Should have no base version", (boolean)entry.hasBaseVersion());
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix1Corrupted.getFileName());
        hotfix1Corrupted.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles(new String[0]);
        hotfix1Corrupted.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertFalse((String)"Should have no base version", (boolean)entry.hasBaseVersion());
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix1Corrupted.getFileName());
        HotFixPackage2 hotfix2 = new HotFixPackage2();
        hotfix2.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertTrue((String)"Should have a base version", (boolean)entry.hasBaseVersion());
        Assert.assertEquals((String)"Nb versions in registry", (long)2L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix2.getFileName());
        hotfix2.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix1Corrupted.getFileName());
        hotfix1Corrupted.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles(new String[0]);
        List caughtEvents = this.logCaptureResult.getCaughtEventMessages();
        Assert.assertEquals((long)3L, (long)caughtEvents.size());
        Assert.assertEquals((Object)String.format("Use of the <copy /> command on JAR files is not recommended, prefer using <update /> command to ensure a safe rollback. (%s)", "some-jar-5.6.0-HF01.jar"), caughtEvents.get(0));
        Assert.assertEquals((Object)String.format("Use of the <copy /> command on JAR files is not recommended, prefer using <update /> command to ensure a safe rollback. (%s)", "some-jar-5.6.0-HF01.jar"), caughtEvents.get(1));
        Assert.assertEquals((Object)String.format("Registry repaired: JAR introduced without corresponding entry in the registry (copy task?) : bundles%s", File.separator + JARNAME), caughtEvents.get(2));
    }

    @Test
    @LogCaptureFeature.FilterWith(value=RegistryCorruptionLogFilter.class)
    public void testHotfixUninstallWithCorruptedRegistry2() throws Exception {
        UpdateManager mgr = this.getManager();
        Assert.assertEquals((long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles(new String[0]);
        File bak = new File(mgr.getBackupRoot(), "bundles");
        if (bak.isDirectory()) {
            Assert.assertEquals((long)0L, (long)bak.list().length);
        }
        HotFixPackage1 hotfix1 = new HotFixPackage1();
        hotfix1.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        Entry entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertFalse((String)"Should have no base version", (boolean)entry.hasBaseVersion());
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        this.ensureFiles(new String[0]);
        HotFixPackage2Corrupted hotfix2Corrupted = new HotFixPackage2Corrupted();
        hotfix2Corrupted.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertFalse((String)"Should have no base version", (boolean)entry.hasBaseVersion());
        Assert.assertEquals((String)"Nb versions in registry", (long)2L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix2Corrupted.getFileName());
        HotFixPackage3 hotfix3 = new HotFixPackage3();
        hotfix3.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertTrue((String)"Should have a base version", (boolean)entry.hasBaseVersion());
        Assert.assertEquals((Object)"5.6.0-HF02", (Object)entry.getBaseVersion().getVersion());
        Assert.assertEquals((String)"Nb versions in registry", (long)3L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix3.getFileName());
        HotFixPackage4 hotfix4 = new HotFixPackage4();
        hotfix4.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertTrue((String)"Should have a base version", (boolean)entry.hasBaseVersion());
        Assert.assertEquals((Object)"5.6.0-HF02", (Object)entry.getBaseVersion().getVersion());
        Assert.assertEquals((String)"Nb versions in registry", (long)4L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix4.getFileName());
        hotfix4.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertTrue((String)"Should have a base version", (boolean)entry.hasBaseVersion());
        Assert.assertEquals((Object)"5.6.0-HF02", (Object)entry.getBaseVersion().getVersion());
        Assert.assertEquals((String)"Nb versions in registry", (long)3L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix3.getFileName());
        hotfix3.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertTrue((String)"Should have a base version", (boolean)entry.hasBaseVersion());
        Assert.assertEquals((Object)"5.6.0-HF02", (Object)entry.getBaseVersion().getVersion());
        Assert.assertEquals((String)"Nb versions in registry", (long)2L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix2Corrupted.getFileName());
        hotfix2Corrupted.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertTrue((String)"Should have a base version", (boolean)entry.hasBaseVersion());
        Assert.assertEquals((Object)"5.6.0-HF02", (Object)entry.getBaseVersion().getVersion());
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        this.ensureFiles(new String[0]);
        hotfix1.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles(new String[0]);
        List caughtEvents = this.logCaptureResult.getCaughtEventMessages();
        Assert.assertEquals((long)3L, (long)caughtEvents.size());
        Assert.assertEquals((Object)String.format("Use of the <copy /> command on JAR files is not recommended, prefer using <update /> command to ensure a safe rollback. (%s)", "some-jar-5.6.0-HF02.jar"), caughtEvents.get(0));
        Assert.assertEquals((Object)String.format("Registry repaired: JAR introduced without corresponding entry in the registry (copy task?) : bundles%s", File.separator + JARNAME), caughtEvents.get(1));
        Assert.assertEquals((Object)String.format("Could not rollback version bundles%s since the backup file was not found", File.separator + "some-jar-5.6.0-HF02.jar"), caughtEvents.get(2));
    }

    @Test
    public void testUpgradeOnly1() throws Exception {
        UpdateManager mgr = this.getManager();
        Assert.assertEquals((long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles(new String[0]);
        File bak = new File(mgr.getBackupRoot(), "bundles");
        if (bak.isDirectory()) {
            Assert.assertEquals((long)0L, (long)bak.list().length);
        }
        AddonPackage addon = new AddonPackage();
        addon.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        Entry entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertFalse((String)"Should have no base version", (boolean)entry.hasBaseVersion());
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        this.ensureFiles(addon.getFileName());
        HotFixPackage2 hotfix2 = new HotFixPackage2();
        hotfix2.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)2L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix2.getFileName());
        hotfix2.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        this.ensureFiles(addon.getFileName());
        addon.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles(new String[0]);
    }

    @Test
    public void testUpgradeOnly2() throws Exception {
        UpdateManager mgr = this.getManager();
        Assert.assertEquals((long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles(new String[0]);
        File bak = new File(mgr.getBackupRoot(), "bundles");
        if (bak.isDirectory()) {
            Assert.assertEquals((long)0L, (long)bak.list().length);
        }
        AddonPackage addon = new AddonPackage();
        addon.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        Entry entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertFalse((String)"Should have no base version", (boolean)entry.hasBaseVersion());
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        this.ensureFiles(addon.getFileName());
        HotFixPackage2 hotfix2 = new HotFixPackage2();
        hotfix2.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)2L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix2.getFileName());
        addon.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        Assert.assertNull((String)"Remaining version should be upgradeOnly", (Object)entry.getLastVersion(false));
        this.ensureFiles(new String[0]);
    }

    @Test
    public void testUpgradeOnly3() throws Exception {
        UpdateManager mgr = this.getManager();
        Assert.assertEquals((long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles(new String[0]);
        File bak = new File(mgr.getBackupRoot(), "bundles");
        if (bak.isDirectory()) {
            Assert.assertEquals((long)0L, (long)bak.list().length);
        }
        HotFixPackage2 hotfix2 = new HotFixPackage2();
        hotfix2.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        Entry entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertFalse((String)"Should have no base version", (boolean)entry.hasBaseVersion());
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        this.ensureFiles(new String[0]);
        AddonPackage addon = new AddonPackage();
        addon.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)2L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix2.getFileName());
        hotfix2.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        this.ensureFiles(addon.getFileName());
        addon.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles(new String[0]);
    }

    @Test
    public void testUpgradeOnly4() throws Exception {
        UpdateManager mgr = this.getManager();
        Assert.assertEquals((long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles(new String[0]);
        File bak = new File(mgr.getBackupRoot(), "bundles");
        if (bak.isDirectory()) {
            Assert.assertEquals((long)0L, (long)bak.list().length);
        }
        HotFixPackage2 hotfix2 = new HotFixPackage2();
        hotfix2.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        Entry entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertFalse((String)"Should have no base version", (boolean)entry.hasBaseVersion());
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        this.ensureFiles(new String[0]);
        AddonPackage addon = new AddonPackage();
        addon.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)2L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix2.getFileName());
        addon.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        Assert.assertNull((String)"Remaining version should be upgradeOnly", (Object)entry.getLastVersion(false));
        this.ensureFiles(new String[0]);
    }

    @Test
    public void testUpgradeOnlyWithHotfixUninstall() throws Exception {
        UpdateManager mgr = this.getManager();
        Assert.assertEquals((long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles(new String[0]);
        File bak = new File(mgr.getBackupRoot(), "bundles");
        if (bak.isDirectory()) {
            Assert.assertEquals((long)0L, (long)bak.list().length);
        }
        AddonPackage addon = new AddonPackage();
        addon.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        Entry entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertFalse((String)"Should have no base version", (boolean)entry.hasBaseVersion());
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        this.ensureFiles(addon.getFileName());
        HotFixPackage1 hotfix1 = new HotFixPackage1();
        hotfix1.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)2L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix1.getFileName());
        HotFixPackage2 hotfix2 = new HotFixPackage2();
        hotfix2.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)3L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix2.getFileName());
        hotfix2.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)2L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix1.getFileName());
        addon.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles" + File.separator + JARNAME);
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        Assert.assertNull((String)"Remaining version should be upgradeOnly", (Object)entry.getLastVersion(false));
        this.ensureFiles(new String[0]);
    }

    public static class RegistryCorruptionLogFilter
    implements LogCaptureFeature.Filter {
        public boolean accept(LogEvent event) {
            return event.getLevel().equals((Object)Level.WARN) && (event.getLoggerName().contains("UpdateManager") || event.getLoggerName().contains("Copy"));
        }
    }

    public class HotFixPackage4
    extends HotFixPackage1 {
        @Override
        public String getFileName() {
            return "some-jar-5.6.0-HF04.jar";
        }

        public HotFixPackage4() {
            super("5.6.0-HF04", "1.0.0", PackageType.HOT_FIX, TestRollback.this.service);
        }
    }

    public class HotFixPackage3
    extends HotFixPackage1 {
        @Override
        public String getFileName() {
            return "some-jar-5.6.0-HF03.jar";
        }

        public HotFixPackage3() {
            super("5.6.0-HF03", "1.0.0", PackageType.HOT_FIX, TestRollback.this.service);
        }
    }

    public class HotFixPackage2Corrupted
    extends HotFixPackage2 {
        @Override
        protected void writeInstallCommands(XmlWriter writer) {
            writer.start("update");
            writer.attr("file", "${package.root}/bundles");
            writer.attr("todir", "${env.bundles}");
            writer.attr("upgradeOnly", "true");
            writer.end();
            writer.start("copy");
            writer.attr("file", "${package.root}/bundles/" + this.getFileName());
            writer.attr("todir", "${env.bundles}");
            writer.attr("overwrite", "true");
            writer.end();
        }
    }

    public class HotFixPackage2
    extends HotFixPackage1 {
        @Override
        public String getFileName() {
            return "some-jar-5.6.0-HF02.jar";
        }

        public HotFixPackage2() {
            super("5.6.0-HF02", "1.0.0", PackageType.HOT_FIX, TestRollback.this.service);
        }
    }

    public class HotFixPackage1Corrupted
    extends HotFixPackage1 {
        @Override
        protected void writeInstallCommands(XmlWriter writer) {
            writer.start("update");
            writer.attr("file", "${package.root}/bundles");
            writer.attr("todir", "${env.bundles}");
            writer.attr("upgradeOnly", "true");
            writer.end();
            writer.start("copy");
            writer.attr("file", "${package.root}/bundles/" + this.getFileName());
            writer.attr("todir", "${env.bundles}");
            writer.attr("overwrite", "true");
            writer.end();
        }
    }

    public class HotFixPackage1
    extends AddonPackage {
        @Override
        public String getFileName() {
            return "some-jar-5.6.0-HF01.jar";
        }

        public HotFixPackage1() {
            super("5.6.0-HF01", "1.0.0", PackageType.HOT_FIX, TestRollback.this.service);
        }

        public HotFixPackage1(String name, String version, PackageType type, PackageUpdateService service) {
            super(name, version, type, service);
        }

        @Override
        protected void writeInstallCommands(XmlWriter writer) throws Exception {
            writer.start("update");
            writer.attr("file", "${package.root}/bundles");
            writer.attr("todir", "${env.bundles}");
            writer.attr("upgradeOnly", "true");
            writer.end();
        }
    }

    public class AddonPackage
    extends PackageDef {
        public String getFileName() {
            return "some-jar-5.6.jar";
        }

        public AddonPackage() {
            super("some-addon", "1.0.0", PackageType.ADDON, TestRollback.this.service);
        }

        public AddonPackage(String name, String version, PackageType type, PackageUpdateService service) {
            super(name, version, type, service);
        }

        @Override
        protected void writeInstallCommands(XmlWriter writer) throws Exception {
            writer.start("update");
            writer.attr("file", "${package.root}/bundles");
            writer.attr("todir", "${env.bundles}");
            writer.end();
        }

        @Override
        protected void updatePackage() throws Exception {
            this.addFile("bundles" + File.separator + this.getFileName(), this.getFileName());
        }
    }
}

