/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.guards;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.task.guards.PackagesHelper;

public class PackagesHelperTest {
    @Mock
    private PackageUpdateService service;
    @Mock
    private LocalPackage packageA1;
    @Mock
    private LocalPackage packageA2;
    @InjectMocks
    private PackagesHelper helper;
    private final List<LocalPackage> packages = new ArrayList<LocalPackage>();

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.helper = new PackagesHelper(this.service);
        this.packages.add(this.packageA1);
        this.packages.add(this.packageA2);
    }

    @After
    public void tearDown() {
        this.packages.clear();
    }

    @Test
    public void contains_packagesWithSameName() throws Exception {
        Mockito.when((Object)this.packageA1.getName()).thenReturn((Object)"A");
        Mockito.when((Object)this.packageA2.getName()).thenReturn((Object)"A");
        Mockito.when((Object)this.packageA1.getPackageState()).thenReturn((Object)PackageState.DOWNLOADED);
        Mockito.when((Object)this.packageA2.getPackageState()).thenReturn((Object)PackageState.INSTALLED);
        Mockito.when((Object)this.service.getPackages()).thenReturn(this.packages);
        Assertions.assertThat((boolean)this.helper.contains("A")).isTrue();
    }
}

