/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.xml;

import org.apache.commons.lang3.mutable.MutableObject;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.connect.data.PackageDescriptor;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.Version;
import org.nuxeo.connect.update.model.PackageDefinition;
import org.nuxeo.connect.update.model.TaskDefinition;
import org.nuxeo.connect.update.xml.TaskDefinitionImpl;
import org.nuxeo.connect.update.xml.XmlSerializer;
import org.nuxeo.connect.update.xml.XmlWriter;

@XObject(value="package")
public class PackageDefinitionImpl
implements PackageDefinition {
    @XNode(value="@name")
    protected String name;
    @XNode(value="@version")
    protected Version version;
    @XNode(value="@type")
    protected PackageType type;
    @XNode(value="title")
    protected String title;
    @XNode(value="description")
    protected String description;
    @XNode(value="classifier")
    protected String classifier;
    @XNode(value="vendor")
    protected String vendor;
    @XNode(value="hotreload-support")
    protected boolean hotReloadSupport = false;
    @XNode(value="require-terms-and-conditions-acceptance")
    protected boolean requireTermsAndConditionsAcceptance = false;
    @XNode(value="license")
    protected String license;
    @XNode(value="license-url")
    protected String licenseUrl;
    protected String[] platforms;
    @XNodeList(value="dependencies/package", type=PackageDependency[].class, componentType=PackageDependency.class)
    protected PackageDependency[] dependencies;
    @XNodeList(value="optional-dependencies/package", type=PackageDependency[].class, componentType=PackageDependency.class)
    protected PackageDependency[] optionalDependencies;
    @XNodeList(value="conflicts/package", type=PackageDependency[].class, componentType=PackageDependency.class)
    protected PackageDependency[] conflicts;
    @XNodeList(value="provides/package", type=PackageDependency[].class, componentType=PackageDependency.class)
    protected PackageDependency[] provides;
    @XNode(value="installer")
    protected TaskDefinitionImpl installer;
    @XNode(value="uninstaller")
    protected TaskDefinitionImpl uninstaller;
    @XNode(value="validator")
    protected String validator;

    public String getId() {
        if (this.version == null) {
            return this.name;
        }
        return this.name + "-" + this.version.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.dependencies = PackageDescriptor.fixDependencies((String)name, (PackageDependency[])this.dependencies);
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PackageType getType() {
        return this.type;
    }

    public void setType(PackageType type) {
        this.type = type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    @Deprecated
    public String getLicense() {
        return this.getLicenseType();
    }

    public String getLicenseType() {
        return this.license;
    }

    @Deprecated
    public void setLicense(String license) {
        this.setLicenseType(license);
    }

    public void setLicenseType(String license) {
        this.license = license;
    }

    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    @Deprecated
    public String[] getPlatforms() {
        return this.getTargetPlatforms();
    }

    public String[] getTargetPlatforms() {
        return this.platforms;
    }

    @Deprecated
    public void setPlatforms(String[] platforms) {
        this.setTargetPlatforms(platforms);
    }

    @XNodeList(value="platforms/platform", type=String[].class, componentType=String.class)
    public void setTargetPlatforms(String[] platforms) {
        MutableObject packageDependencies = new MutableObject();
        this.platforms = PackageDescriptor.fixTargetPlatforms((String)this.name, (String[])platforms, (MutableObject)packageDependencies);
        this.setDependencies((PackageDependency[])packageDependencies.getValue());
    }

    public PackageDependency[] getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(PackageDependency[] dependencies) {
        this.dependencies = PackageDescriptor.addPackageDependencies((PackageDependency[])this.dependencies, (PackageDependency[])dependencies);
    }

    public PackageDependency[] getOptionalDependencies() {
        return this.optionalDependencies;
    }

    public void setOptionalDependencies(PackageDependency[] optionalDependencies) {
        this.optionalDependencies = optionalDependencies;
    }

    public PackageDependency[] getConflicts() {
        return this.conflicts;
    }

    public void setConflicts(PackageDependency[] conflicts) {
        this.conflicts = conflicts;
    }

    public PackageDependency[] getProvides() {
        return this.provides;
    }

    public void setProvides(PackageDependency[] provides) {
        this.provides = provides;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public TaskDefinition getInstaller() {
        return this.installer;
    }

    public void setInstaller(TaskDefinition installer) {
        this.installer = installer instanceof TaskDefinitionImpl ? (TaskDefinitionImpl)installer : new TaskDefinitionImpl(installer.getType(), installer.getRequireRestart());
    }

    public TaskDefinition getUninstaller() {
        return this.uninstaller;
    }

    public void setUninstaller(TaskDefinition uninstaller) {
        this.uninstaller = uninstaller instanceof TaskDefinitionImpl ? (TaskDefinitionImpl)uninstaller : new TaskDefinitionImpl(uninstaller.getType(), uninstaller.getRequireRestart());
    }

    public String getValidator() {
        return this.validator;
    }

    public void setValidator(String validator) {
        this.validator = validator;
    }

    public void setHotReloadSupport(boolean hotReloadSupport) {
        this.hotReloadSupport = hotReloadSupport;
    }

    @Deprecated
    public void write(XmlWriter writer) {
        writer.writeXmlDecl();
        writer.start("package");
        writer.attr("name", this.name);
        if (this.version != null) {
            writer.attr("version", this.version.toString());
        }
        if (this.type != null) {
            writer.attr("type", this.type.getValue());
        }
        writer.startContent();
        writer.element("title", this.title);
        writer.element("description", this.description);
        writer.element("classifier", this.classifier);
        writer.element("vendor", this.vendor);
        writer.element("license", this.license);
        writer.element("license-url", this.licenseUrl);
        writer.element("hotreload-support", Boolean.valueOf(this.hotReloadSupport).toString());
        writer.element("require-terms-and-conditions-acceptance", Boolean.valueOf(this.requireTermsAndConditionsAcceptance).toString());
        if (this.platforms != null) {
            writer.start("platforms");
            writer.startContent();
            for (String string : this.platforms) {
                writer.element("platform", string);
            }
            writer.end("platforms");
        }
        if (this.dependencies != null) {
            writer.start("dependencies");
            writer.startContent();
            for (String string : this.dependencies) {
                writer.element("package", string.toString());
            }
            writer.end("dependencies");
        }
        if (this.optionalDependencies != null) {
            writer.start("optional-dependencies");
            writer.startContent();
            for (String string : this.optionalDependencies) {
                writer.element("package", string.toString());
            }
            writer.end("optional-dependencies");
        }
        if (this.installer != null) {
            writer.start("installer");
            writer.attr("class", this.installer.getType());
            writer.attr("restart", String.valueOf(this.installer.getRequireRestart()));
            writer.end();
        }
        if (this.uninstaller != null) {
            writer.start("uninstaller");
            writer.attr("class", this.uninstaller.getType());
            writer.attr("restart", String.valueOf(this.uninstaller.getRequireRestart()));
            writer.end();
        }
        writer.element("validator", this.validator);
        writer.end("package");
    }

    public boolean supportsHotReload() {
        return this.hotReloadSupport;
    }

    public void setRequireTermsAndConditionsAcceptance(boolean requireTermsAndConditionsAcceptance) {
        this.requireTermsAndConditionsAcceptance = requireTermsAndConditionsAcceptance;
    }

    public boolean requireTermsAndConditionsAcceptance() {
        return this.requireTermsAndConditionsAcceptance;
    }

    public String toXML() {
        return new XmlSerializer().toXML(this);
    }

    @Deprecated
    public int getState() {
        return PackageState.UNKNOWN.getValue();
    }

    public PackageState getPackageState() {
        return PackageState.UNKNOWN;
    }

    public boolean isLocal() {
        throw new UnsupportedOperationException();
    }
}

