/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.standalone;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Before;
import org.nuxeo.common.Environment;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.standalone.StandaloneUpdateService;

public abstract class PackageTestCase {
    protected static final Log log = LogFactory.getLog(PackageTestCase.class);
    protected PackageUpdateService service;

    @Before
    public void setUp() throws Exception {
        this.setupService();
    }

    @After
    public void tearDown() throws Exception {
        if (this.service instanceof StandaloneUpdateService) {
            this.tearDownStandaloneUpdateService();
        }
    }

    protected void setupService() throws IOException, PackageException {
        File tmpHome = File.createTempFile("tmphome", null);
        FileUtils.forceDelete((File)tmpHome);
        tmpHome.mkdirs();
        Environment env = new Environment(tmpHome);
        env.init();
        this.service = new StandaloneUpdateService(env);
        this.service.initialize();
    }

    protected void tearDownStandaloneUpdateService() {
        FileUtils.deleteQuietly((File)Environment.getDefault().getHome());
    }
}

