/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.standalone;

import java.io.File;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.standalone.PackageTestCase;
import org.nuxeo.connect.update.task.standalone.CommandsTask;
import org.nuxeo.connect.update.task.standalone.InstallTask;
import org.nuxeo.connect.update.task.standalone.UninstallTask;
import org.nuxeo.connect.update.util.PackageBuilder;

public class TestXmlCommands
extends PackageTestCase {
    protected File createPackage() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.name("nuxeo-automation").version("5.3.2").type(PackageType.ADDON);
        builder.platform("dm-5.3.2");
        builder.platform("dam-5.3.2");
        builder.dependency("nuxeo-core:5.3.1:5.3.2");
        builder.dependency("nuxeo-runtime:5.3.1");
        builder.title("Nuxeo Automation");
        builder.description("A service that enables building complex business logic on top of Nuxeo services using scriptable operation chains");
        builder.classifier("Open Source");
        builder.vendor("Nuxeo");
        builder.installer(InstallTask.class.getName(), true);
        builder.uninstaller(UninstallTask.class.getName(), true);
        builder.addLicense("My test license. All rights reserved.");
        File file = File.createTempFile("nxinstall-file-", ".tmp");
        file.deleteOnExit();
        File tofile = File.createTempFile("nxinstall-tofile-", ".tmp");
        tofile.deleteOnExit();
        builder.addInstallScript("<install>\n  <copy file=\"" + file.getAbsolutePath() + "\" tofile=\"" + tofile.getAbsolutePath() + "\" overwrite=\"true\"/>\n</install>\n");
        return builder.build();
    }

    @Test
    public void testReadCommands() throws Exception {
        File zip = this.createPackage();
        this.service.addPackage(zip);
        List pkgs = this.service.getPackages();
        Assert.assertEquals((long)1L, (long)pkgs.size());
        LocalPackage pkg = (LocalPackage)pkgs.get(0);
        Assert.assertEquals((Object)"nuxeo-automation-5.3.2", (Object)pkg.getId());
        Assert.assertEquals((Object)"nuxeo-automation", (Object)pkg.getName());
        Assert.assertEquals((Object)"5.3.2", (Object)pkg.getVersion().toString());
        CommandsTask task = (CommandsTask)pkg.getInstallTask();
        Assert.assertTrue((boolean)task.isRestartRequired());
        task.validate();
        task.run(null);
        Assert.assertEquals((long)1L, (long)task.getCommands().size());
        Assert.assertEquals((long)1L, (long)task.getCommandLog().size());
        Assert.assertTrue((boolean)pkg.getUninstallFile().isFile());
    }
}

