/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.standalone.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.nuxeo.common.Environment;
import org.nuxeo.connect.update.standalone.commands.AbstractCommandTest;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.util.PackageBuilder;
import org.nuxeo.connect.update.xml.XmlWriter;
import org.nuxeo.launcher.config.ConfigurationGenerator;

public class TestConfig
extends AbstractCommandTest {
    private ConfigurationGenerator configurationGenerator;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        URL url = this.getClass().getClassLoader().getResource("config/nuxeo.conf");
        File nuxeoConf = new File(Environment.getDefault().getServerHome(), "nuxeo.conf");
        FileUtils.copyFile((File)new File(URLDecoder.decode(url.getPath(), "UTF-8")), (File)nuxeoConf);
        System.setProperty("nuxeo.conf", nuxeoConf.getPath());
        System.setProperty("tomcat.home", Environment.getDefault().getServerHome().getPath());
        System.setProperty("nuxeo.home", Environment.getDefault().getServerHome().getPath());
        System.setProperty("nuxeo.data.dir", Environment.getDefault().getData().getPath());
        System.setProperty("nuxeo.log.dir", Environment.getDefault().getLog().getPath());
        url = this.getClass().getClassLoader().getResource("templates");
        FileUtils.copyDirectory((File)new File(URLDecoder.decode(url.getPath(), "UTF-8")), (File)new File(Environment.getDefault().getServerHome(), "templates"));
        this.configurationGenerator = new ConfigurationGenerator();
        Assert.assertTrue((boolean)this.configurationGenerator.init());
        this.configurationGenerator.addTemplate("oldtemplate");
    }

    @Override
    protected void updatePackage(PackageBuilder builder) throws Exception {
    }

    @Override
    protected void writeCommand(XmlWriter writer) {
        writer.start("config");
        writer.attr("addtemplate", "newtemplate");
        writer.end();
        writer.start("config");
        writer.attr("rmtemplate", "oldtemplate");
        writer.end();
        writer.start("config");
        writer.attr("set", "test.property=some.value");
        writer.end();
        writer.start("config");
        writer.attr("set", "alreadyset.property=new.value");
        writer.end();
    }

    @Override
    protected void installDone(Task task, Throwable error) throws Exception {
        String line;
        super.installDone(task, error);
        this.configurationGenerator = new ConfigurationGenerator();
        Assert.assertTrue((boolean)this.configurationGenerator.init());
        log.info((Object)"Install done. nuxeo.conf content:");
        BufferedReader reader = new BufferedReader(new FileReader(this.configurationGenerator.getNuxeoConf()));
        while ((line = reader.readLine()) != null) {
            log.info((Object)line);
        }
        reader.close();
        log.info((Object)"END nuxeo.conf content:");
        String templates = this.configurationGenerator.getUserConfig().getProperty("nuxeo.templates");
        Assert.assertTrue((String)"newtemplate was not added", (templates != null && templates.contains("newtemplate") ? 1 : 0) != 0);
        Assert.assertTrue((String)"oldtemplate was not removed", (templates != null && !templates.contains("oldtemplate") ? 1 : 0) != 0);
        Assert.assertEquals((String)"test.property was not set to some.value", (Object)"some.value", (Object)this.configurationGenerator.getUserConfig().getProperty("test.property"));
        Assert.assertEquals((String)"alreadyset.property was not set to its new value", (Object)"new.value", (Object)this.configurationGenerator.getUserConfig().getProperty("alreadyset.property"));
    }

    @Override
    protected void uninstallDone(Task task, Throwable error) throws Exception {
        String line;
        super.uninstallDone(task, error);
        this.configurationGenerator = new ConfigurationGenerator();
        Assert.assertTrue((boolean)this.configurationGenerator.init());
        log.info((Object)"Uninstall done. nuxeo.conf content:");
        BufferedReader reader = new BufferedReader(new FileReader(this.configurationGenerator.getNuxeoConf()));
        while ((line = reader.readLine()) != null) {
            log.info((Object)line);
        }
        reader.close();
        log.info((Object)"END nuxeo.conf content:");
        String templates = this.configurationGenerator.getUserConfig().getProperty("nuxeo.templates");
        Assert.assertTrue((String)"newtemplate was not removed", (templates != null && !templates.contains("newtemplate") ? 1 : 0) != 0);
        Assert.assertTrue((String)"oldtemplate was not reset", (templates != null && templates.contains("oldtemplate") ? 1 : 0) != 0);
        Assert.assertNull((String)"test.property was not removed", (Object)this.configurationGenerator.getUserConfig().getProperty("test.property"));
        Assert.assertEquals((String)"alreadyset.property was not set to its old value", (Object)"old.value", (Object)this.configurationGenerator.getUserConfig().getProperty("alreadyset.property"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        Properties sysProperties = System.getProperties();
        sysProperties.remove("nuxeo.conf");
        sysProperties.remove("nuxeo.home");
        sysProperties.remove("tomcat.home");
        sysProperties.remove("nuxeo.data.dir");
        sysProperties.remove("nuxeo.log.dir");
    }
}

