/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.standalone.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.standalone.commands.AbstractCommandTest;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.util.IOUtils;
import org.nuxeo.connect.update.util.PackageBuilder;
import org.nuxeo.connect.update.xml.XmlWriter;

public class TestCopy
extends AbstractCommandTest {
    private File goldStandardFile;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.goldStandardFile = new File(Environment.getDefault().getConfig(), "goldstandard.properties");
        FileUtils.writeFile((File)this.goldStandardFile, (String)"param1=value1");
    }

    @Override
    protected void updatePackage(PackageBuilder builder) throws Exception {
        File props = File.createTempFile("test-commands-", ".properties");
        props.deleteOnExit();
        FileUtils.writeFile((File)props, (String)"test=my value");
        builder.addEntry("test.properties", (InputStream)new FileInputStream(props));
        props = File.createTempFile("test-commands-", ".properties");
        props.deleteOnExit();
        FileUtils.writeFile((File)props, (String)"param2=value2");
        builder.addEntry("append.properties", (InputStream)new FileInputStream(props));
        props = File.createTempFile("test-commands-", ".properties");
        props.deleteOnExit();
        FileUtils.writeFile((File)props, (String)"param3=value3");
        builder.addEntry("append2.properties", (InputStream)new FileInputStream(props));
    }

    @Override
    protected void writeCommand(XmlWriter writer) {
        writer.start("copy");
        writer.attr("file", "${package.root}/test.properties");
        writer.attr("todir", "${env.config}");
        writer.end();
        writer.start("copy");
        writer.attr("file", "${package.root}/append.properties");
        writer.attr("tofile", "${env.config}/goldstandard.properties");
        writer.attr("append", "true");
        writer.end();
        writer.start("append");
        writer.attr("file", "${package.root}/append2.properties");
        writer.attr("tofile", "${env.config}/goldstandard.properties");
        writer.end();
    }

    @Override
    protected void installDone(Task task, Throwable error) throws Exception {
        super.installDone(task, error);
        LocalPackage pkg = task.getPackage();
        File src = pkg.getData().getEntry("test.properties");
        File dst = this.getTargetFile();
        Assert.assertTrue((boolean)dst.isFile());
        Assert.assertEquals((Object)IOUtils.createMd5((File)src), (Object)IOUtils.createMd5((File)dst));
        Properties goldstandard = new Properties();
        goldstandard.load(new FileInputStream(this.goldStandardFile));
        Assert.assertEquals((String)"Original property is missing", (Object)"value1", (Object)goldstandard.getProperty("param1"));
        Assert.assertEquals((String)"Appended property is missing", (Object)"value2", (Object)goldstandard.getProperty("param2"));
        Assert.assertEquals((String)"Appended property is missing", (Object)"value3", (Object)goldstandard.getProperty("param3"));
    }

    @Override
    protected void uninstallDone(Task task, Throwable error) throws Exception {
        super.uninstallDone(task, error);
        Assert.assertFalse((boolean)this.getTargetFile().exists());
        Properties goldstandard = new Properties();
        goldstandard.load(new FileInputStream(this.goldStandardFile));
        Assert.assertEquals((String)"Original property is missing", (Object)"value1", (Object)goldstandard.getProperty("param1"));
        Assert.assertNull((String)"Appended property must be removed", (Object)goldstandard.getProperty("param2"));
        Assert.assertNull((String)"Appended property must be removed", (Object)goldstandard.getProperty("param3"));
    }

    protected File getTargetFile() {
        return new File(Environment.getDefault().getConfig(), "test.properties");
    }
}

