/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.PackageValidationException;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.util.PackageBuilder;
import org.nuxeo.connect.update.xml.XmlWriter;

public abstract class PackageDef {
    private static final Log log = LogFactory.getLog(PackageDef.class);
    private File pkgFile;
    protected LocalPackage pkg;
    protected PackageBuilder builder = new PackageBuilder();
    protected boolean allowDowngrade = false;
    protected boolean upgradeOnly = false;
    private PackageUpdateService service;

    public PackageDef(String name, String version, PackageUpdateService service) throws Exception {
        this(name, version, PackageType.ADDON, service);
    }

    public PackageDef(String name, String version, PackageType type, PackageUpdateService service) throws Exception {
        this(name, version, type, "dm-" + version, service);
    }

    public PackageDef(String name, String version, PackageType type, String targetVersion, PackageUpdateService service) {
        this.builder.name(name).version(version).type(type);
        this.builder.platform(targetVersion);
        this.builder.title("Test Package: " + name);
        this.builder.description("A test package");
        this.builder.classifier("Open Source");
        this.builder.vendor("Nuxeo");
        this.builder.addLicense("My test license. All rights reserved.");
        this.service = service;
    }

    public void setUpgradeOnly(boolean upgradeOnly) {
        this.upgradeOnly = upgradeOnly;
    }

    public void setAllowDowngrade(boolean allowDowngrade) {
        this.allowDowngrade = allowDowngrade;
    }

    public File getPackageFile() throws Exception {
        if (this.pkgFile == null) {
            this.updatePackage();
            XmlWriter writer = new XmlWriter();
            writer.start("install");
            writer.startContent();
            this.writeInstallCommands(writer);
            writer.end("install");
            this.builder.addInstallScript(writer.toString());
            this.pkgFile = this.builder.build();
        }
        return this.pkgFile;
    }

    public String getId() {
        if (this.pkg == null) {
            throw new IllegalStateException("package was not installed");
        }
        return this.pkg.getId();
    }

    public LocalPackage getPackage() {
        return this.pkg;
    }

    public LocalPackage download() throws Exception {
        if (this.pkg != null) {
            return this.pkg;
        }
        this.pkg = this.service.addPackage(this.getPackageFile());
        return this.pkg;
    }

    public void install() throws Exception {
        Task task;
        ValidationStatus status;
        if (this.pkg == null) {
            this.download();
        }
        if ((status = (task = this.pkg.getInstallTask()).validate()).hasErrors()) {
            throw new PackageValidationException(status);
        }
        try {
            task.run(new HashMap());
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            task.rollback();
        }
    }

    public void uninstall() throws Exception {
        if (this.pkg == null) {
            throw new IllegalStateException("Package was not installed");
        }
        Task task = this.pkg.getUninstallTask();
        ValidationStatus status = task.validate();
        if (status.hasErrors()) {
            throw new PackageValidationException(status);
        }
        try {
            task.run(new HashMap());
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            task.rollback();
        }
    }

    protected abstract void updatePackage() throws Exception;

    protected abstract void writeInstallCommands(XmlWriter var1) throws Exception;

    public void addFile(String name, URL url) throws Exception {
        this.builder.addEntry(name, url.openStream());
    }

    public void addFile(String name, String content) throws Exception {
        this.builder.addEntry(name, (InputStream)new ByteArrayInputStream(content.getBytes()));
    }
}

