/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.guards;

import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.Package;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageUpdateService;

public class PackagesHelper {
    private final PackageUpdateService service;

    public PackagesHelper(PackageUpdateService service) {
        this.service = service;
    }

    public boolean contains(String name) {
        try {
            if (name.contains(":")) {
                LocalPackage pkg = this.service.getPackage(name = name.replace(':', '-'));
                return pkg != null && this.isPackageInstalled((Package)pkg);
            }
            for (Package pkg : this.service.getPackages()) {
                if (!pkg.getName().equals(name)) continue;
                return this.isPackageInstalled(pkg);
            }
            return false;
        }
        catch (PackageException e) {
            return false;
        }
    }

    protected boolean isPackageInstalled(Package pkg) {
        PackageState state = pkg.getPackageState();
        switch (state) {
            case INSTALLING: 
            case INSTALLED: 
            case STARTED: {
                return true;
            }
        }
        return false;
    }
}

