/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jboss.deployer;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.virtual.VirtualFile;
import org.nuxeo.runtime.jboss.deployer.AbstractNuxeoDeployer;
import org.nuxeo.runtime.jboss.deployer.Bootstrap;
import org.nuxeo.runtime.jboss.deployer.Utils;
import org.nuxeo.runtime.jboss.deployer.structure.DeploymentStructure;
import org.nuxeo.runtime.jboss.deployer.structure.NuxeoStructureDeployer;

public class NuxeoLauncher
extends AbstractNuxeoDeployer {
    public static final String NUXEO_HOME_DIR = "nuxeo.home.dir";
    public static final String NUXEO_EAR_DIR = "nuxeo.ear.dir";
    protected File home;

    public NuxeoLauncher() {
        this.setStage(DeploymentStages.INSTALLED);
    }

    public File getNuxeoHome() {
        return this.home;
    }

    public File getRealNuxeoZipFile(VFSDeploymentUnit unit) throws Exception {
        File file;
        String name = unit.getName();
        int p = name.indexOf(58);
        if (p > -1) {
            name = name.substring(p + 1);
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        return (file = new File(name)).isFile() ? file : null;
    }

    @Override
    protected void doDeploy(VFSDeploymentUnit unit) throws Exception {
        DeploymentStructure md = NuxeoStructureDeployer.popStructure(unit.getRoot().getName());
        if (md == null) {
            VirtualFile root = unit.getRoot();
            md = NuxeoStructureDeployer.accept(root);
            if (md == null) {
                return;
            }
            File realzip = this.getRealNuxeoZipFile(unit);
            md.initialize(realzip != null ? realzip.lastModified() : 0L);
        }
        ClassLoader cl = unit.getClassLoader();
        this.home = md.getHome();
        this.log.info((Object)("Launching Nuxeo from: " + this.home));
        Map<String, String> props = md.getProperties();
        Properties sysprops = System.getProperties();
        sysprops.setProperty(NUXEO_EAR_DIR, this.home.getAbsolutePath());
        String v = props.get(NUXEO_HOME_DIR);
        if (v != null) {
            v = Utils.expandVars(v, sysprops);
            this.home = new File(v);
            this.home.mkdirs();
        }
        File[] bundles = md.getResolvedBundleFiles();
        Bootstrap b = new Bootstrap(this.home, Arrays.asList(bundles), cl);
        b.getProperties().putAll(props);
        b.startNuxeo();
    }

    @Override
    protected void doUndeploy(VFSDeploymentUnit unit) throws Exception {
        ClassLoader cl = unit.getClassLoader();
        File homeDir = this.home != null ? this.home : Utils.getRealHomeDir(unit.getRoot());
        new Bootstrap(homeDir, null, cl).stopNuxeo();
    }
}

