/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jboss.deployer.structure;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.StructureMetaDataFactory;
import org.jboss.deployers.vfs.plugins.structure.AbstractVFSStructureDeployer;
import org.jboss.deployers.vfs.spi.structure.StructureContext;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.metadata.ear.spec.ModuleMetaData;
import org.jboss.metadata.ear.spec.ModulesMetaData;
import org.jboss.virtual.VirtualFile;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;
import org.nuxeo.runtime.jboss.deployer.structure.DeploymentStructure;
import org.nuxeo.runtime.jboss.deployer.structure.DeploymentStructureReader;
import org.nuxeo.runtime.jboss.deployer.structure.PathMatcher;
import org.nuxeo.runtime.jboss.deployer.structure.PathPattern;

public class NuxeoStructureDeployer
extends AbstractVFSStructureDeployer {
    public static final String NUXEO_STRUCTURE_XML = "META-INF/nuxeo-structure.xml";
    public static final String NUXEO_PREPROCESSOR_FILE = "META-INF/nuxeo-preprocessor.xml";
    protected static Map<String, DeploymentStructure> structures;
    protected boolean useValidation = true;
    protected boolean includeEarRootInClasspath = true;
    protected boolean includeManifestClassPath = false;
    protected SchemaBindingResolver resolver = SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();
    protected UnmarshallerFactory unmarshallerFactory = UnmarshallerFactory.newInstance();

    public static synchronized DeploymentStructure popStructure(String key) {
        if (structures != null) {
            DeploymentStructure ds = structures.remove(key);
            if (structures.isEmpty()) {
                structures = null;
            }
            return ds;
        }
        return null;
    }

    public static synchronized DeploymentStructure peekStructure(String key) {
        if (structures != null) {
            return structures.get(key);
        }
        return null;
    }

    public static synchronized void pushStructure(String key, DeploymentStructure ds) {
        if (structures == null) {
            structures = new HashMap<String, DeploymentStructure>();
        }
        structures.put(key, ds);
    }

    public NuxeoStructureDeployer() {
        this.setRelativeOrder(10);
    }

    public SchemaBindingResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(SchemaBindingResolver resolver) {
        this.resolver = resolver;
    }

    public void setIncludeEarRootInClasspath(boolean includeEarRootInClasspath) {
        this.includeEarRootInClasspath = includeEarRootInClasspath;
    }

    public boolean isIncludeEarRootInClasspath() {
        return this.includeEarRootInClasspath;
    }

    public void setIncludeManifestClassPath(boolean includeManifestClassPath) {
        this.includeManifestClassPath = includeManifestClassPath;
    }

    public boolean isIncludeManifestClassPath() {
        return this.includeManifestClassPath;
    }

    public void setUseValidation(boolean validateXml) {
        this.useValidation = validateXml;
    }

    public boolean isUseValidation() {
        return this.useValidation;
    }

    public boolean determineStructure(StructureContext structureContext) throws DeploymentException {
        VirtualFile root = structureContext.getFile();
        try {
            JBossAppMetaData earMetaData;
            double start = System.currentTimeMillis();
            DeploymentStructure md = NuxeoStructureDeployer.accept(root);
            if (md == null) {
                return false;
            }
            md.initialize(0L);
            this.log.info((Object)("Found Nuxeo Deployment: " + root.getName()));
            File[] bundles = md.getResolvedBundleFiles();
            if (md.isRequirePreprocessing()) {
                this.preprocess(md, bundles);
            }
            if ((earMetaData = this.loadEarMetaData(root)) != null) {
                this.createEarSubdeployments(structureContext, earMetaData);
            }
            for (DeploymentStructure.Context ctx : md.getContexts()) {
                this.createContext(structureContext, ctx);
            }
            String[] children = md.getChildren();
            if (children != null) {
                for (String c : children) {
                    VirtualFile child = root.getChild(c);
                    if (child != null) {
                        structureContext.determineChildStructure(child);
                        continue;
                    }
                    this.log.warn((Object)("Sub-deployment " + c + " not found in " + root.getName()));
                }
            }
            this.createBundlesClasspath(structureContext, md, earMetaData);
            NuxeoStructureDeployer.pushStructure(root.getName(), md);
            this.log.info((Object)("Determining Nuxeo Deployment Structure took " + ((double)System.currentTimeMillis() - start) / 1000.0 + " sec."));
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
        return true;
    }

    protected void createContext(StructureContext structureContext, DeploymentStructure.Context ctx) throws IOException {
        String[] cp;
        PathPattern pattern;
        VirtualFile root = structureContext.getFile();
        String path = ctx.getPath();
        if (path.indexOf(42) > -1 && (path = (pattern = PathPattern.parse(path)).findFirstMatchingPath(root)) == null) {
            this.log.warn((Object)("No such context was found " + ctx.getPath() + " in " + root.getName()));
            return;
        }
        ContextInfo ci = this.createNamedContext(structureContext, path);
        String[] mp = ctx.getMetaDataPath();
        if (mp != null) {
            for (String p : mp) {
                ci.addMetaDataPath(p);
            }
        }
        if ((cp = ctx.getClasspath()) != null) {
            PathMatcher matcher = new PathMatcher();
            matcher.addPatterns(cp);
            List<VirtualFile> cpFiles = matcher.getMatches(root);
            for (VirtualFile file : cpFiles) {
                this.addClassPath(structureContext, file, true, this.includeManifestClassPath, ci);
            }
        }
    }

    protected ContextInfo createNamedContext(StructureContext structureContext, String name) {
        ContextInfo context = StructureMetaDataFactory.createContextInfo((String)name, null);
        this.applyStructure(structureContext, context);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeploymentStructure loadConfig(VirtualFile root) throws Exception {
        VirtualFile vf = root.getChild(NUXEO_STRUCTURE_XML);
        if (vf == null) {
            return null;
        }
        InputStream in = vf.openStream();
        try {
            DeploymentStructure deploymentStructure = new DeploymentStructureReader().read(root, in);
            return deploymentStructure;
        }
        finally {
            in.close();
        }
    }

    public static DeploymentStructure accept(VirtualFile root) throws Exception {
        if (root.isLeaf()) {
            return null;
        }
        return NuxeoStructureDeployer.loadConfig(root);
    }

    protected void createBundlesClasspath(StructureContext structureContext, DeploymentStructure md, JBossAppMetaData earMd) throws Exception {
        ContextInfo ci = structureContext.getMetaData().getContext("");
        if (ci == null) {
            throw new DeploymentException("A Nuxeo application must declare a root context (a context with path == \"\")");
        }
        VirtualFile root = structureContext.getFile();
        String[] paths = md.getResolvedBundles();
        if (paths == null || paths.length == 0) {
            throw new DeploymentException("A Nuxeo application must declare at last one bundle");
        }
        this.addClassPath(structureContext, root, this.includeEarRootInClasspath, this.includeManifestClassPath, ci);
        ModulesMetaData modules = null;
        if (earMd != null) {
            modules = earMd.getModules();
        }
        if (modules != null) {
            this.applyClassPath(structureContext, ci, md.getHome(), root, paths, modules);
        } else {
            this.applyClassPath(structureContext, ci, md.getHome(), root, paths);
        }
    }

    protected void applyClassPath(StructureContext structureContext, ContextInfo ci, File home, VirtualFile root, String[] paths, ModulesMetaData modules) throws IOException {
        for (String path : paths) {
            if (modules.get(path) == null) {
                VirtualFile vfile = root.getChild(path);
                if (vfile == null) {
                    throw new IOException("Relative file " + path + "doesn't exists");
                }
                this.addClassPath(structureContext, vfile, true, this.includeManifestClassPath, ci);
                continue;
            }
            this.log.debug((Object)("Not adding EAR module to root classpath: " + path));
        }
    }

    protected void applyClassPath(StructureContext structureContext, ContextInfo ci, File home, VirtualFile root, String[] paths) throws IOException {
        for (String path : paths) {
            VirtualFile vfile = root.getChild(path);
            if (vfile == null) {
                throw new IOException("Relative file " + path + "doesn't exists");
            }
            this.addClassPath(structureContext, vfile, true, this.includeManifestClassPath, ci);
        }
    }

    protected ClassLoader createPreprocessorClassLoader(DeploymentStructure md) throws Exception {
        String[] cp;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = NuxeoStructureDeployer.class.getClassLoader();
        }
        if ((cp = md.getPreprocessorClassPath()) != null && cp.length > 0) {
            PathMatcher matcher = new PathMatcher();
            matcher.addPatterns(cp);
            List<File> cpFiles = matcher.getMatchesAsFiles(md.getHome());
            URL[] urls = new URL[cpFiles.size()];
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = cpFiles.get(i).toURI().toURL();
            }
            cl = new URLClassLoader(urls, cl);
        }
        return cl;
    }

    public void preprocess(DeploymentStructure md, File[] bundles) throws Exception {
        double start = System.currentTimeMillis();
        System.setProperty("org.nuxeo.runtme.preprocessing.jboss5", "true");
        File metadata = new File(md.getHome(), NUXEO_PREPROCESSOR_FILE);
        if (!metadata.isFile()) {
            this.log.error((Object)"Unable to find META-INF/nuxeo-preprocessor.xml file. Skip preprocessing.");
            return;
        }
        ClassLoader cl = this.createPreprocessorClassLoader(md);
        Class<?> klass = cl.loadClass("org.nuxeo.runtime.deployment.preprocessor.DeploymentPreprocessor");
        Method process = klass.getMethod("process", File.class, File.class, File[].class);
        process.invoke(null, md.getHome(), metadata, bundles);
        this.log.info((Object)("Nuxeo Preprocessing took " + ((double)System.currentTimeMillis() - start) / 1000.0 + " sec."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JBossAppMetaData loadEarMetaData(VirtualFile file) throws Exception {
        VirtualFile applicationXml = file.getChild("META-INF/application.xml");
        VirtualFile jbossAppXml = file.getChild("META-INF/jboss-app.xml");
        if (applicationXml == null && jbossAppXml == null) {
            return null;
        }
        Unmarshaller unmarshaller = this.unmarshallerFactory.newUnmarshaller();
        unmarshaller.setValidation(this.useValidation);
        EarMetaData specMetaData = null;
        if (applicationXml != null) {
            InputStream in = applicationXml.openStream();
            try {
                specMetaData = (EarMetaData)unmarshaller.unmarshal(in, this.resolver);
            }
            finally {
                in.close();
            }
        }
        JBossAppMetaData appMetaData = null;
        if (jbossAppXml != null) {
            InputStream in = jbossAppXml.openStream();
            try {
                appMetaData = (JBossAppMetaData)unmarshaller.unmarshal(in, this.resolver);
            }
            finally {
                in.close();
            }
        }
        if (appMetaData == null) {
            appMetaData = new JBossAppMetaData();
        }
        appMetaData.merge(appMetaData, specMetaData);
        return appMetaData;
    }

    protected void createEarSubdeployments(StructureContext structureContext, JBossAppMetaData appMetaData) throws Exception {
        VirtualFile file = structureContext.getFile();
        ModulesMetaData modules = appMetaData.getModules();
        if (modules != null) {
            for (ModuleMetaData mod : modules) {
                String fileName = mod.getFileName();
                if (fileName == null || (fileName = fileName.trim()).length() <= 0) continue;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Checking application.xml module: " + fileName));
                }
                try {
                    VirtualFile module = file.getChild(fileName);
                    if (module == null) {
                        throw new RuntimeException(fileName + " module listed in application.xml does not exist within .ear " + file.toURI());
                    }
                    if (structureContext.determineChildStructure(module)) continue;
                    throw new RuntimeException(fileName + " module listed in application.xml is not a recognized deployment, .ear: " + file.getName());
                }
                catch (IOException e) {
                    throw new RuntimeException("Exception looking for " + fileName + " module listed in application.xml, .ear " + file.getName(), e);
                }
            }
        }
    }
}

