/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jboss.deployer;

import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Bootstrap {
    protected static final Log log = LogFactory.getLog(Boolean.class);
    protected final File homeDir;
    protected final ClassLoader cl;
    protected final List<File> bundles;
    protected final Map<String, Object> env;
    protected Class<?> frameworkLoaderClass;
    protected long startTime;

    public Bootstrap(File homeDir, List<File> bundles, ClassLoader cl) throws Exception {
        this.homeDir = homeDir;
        this.bundles = bundles;
        this.cl = cl;
        this.env = new HashMap<String, Object>();
        this.frameworkLoaderClass = cl.loadClass("org.nuxeo.osgi.application.loader.FrameworkLoader");
        this.setHostName("JBoss");
        this.setHostVersion("5.1.0");
        this.setDoPreprocessing(false);
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public void setHostName(String value) {
        this.env.put("org.nuxeo.app.host.name", value);
    }

    public void setHostVersion(String value) {
        this.env.put("org.nuxeo.app.host.version", value);
    }

    public void setDoPreprocessing(boolean doPreprocessing) {
        this.env.put("org.nuxeo.app.preprocessing", Boolean.toString(doPreprocessing));
    }

    public void setDevMode(String devMode) {
        this.env.put("org.nuxeo.app.devmode", devMode);
    }

    public void setProperty(String key, Object value) {
        this.env.put(key, value);
    }

    public Map<String, Object> getProperties() {
        return this.env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNuxeo() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldcl = thread.getContextClassLoader();
        thread.setContextClassLoader(this.cl);
        try {
            this.doStart();
        }
        finally {
            thread.setContextClassLoader(oldcl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopNuxeo() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldcl = thread.getContextClassLoader();
        thread.setContextClassLoader(this.cl);
        try {
            this.invokeStop();
        }
        finally {
            thread.setContextClassLoader(oldcl);
        }
    }

    protected void doStart() throws Exception {
        this.startTime = System.currentTimeMillis();
        this.invokeInitialize(this.bundles);
        this.invokeStart();
        this.printStartedMessage();
    }

    protected void printStartedMessage() {
        log.info((Object)("Nuxeo Framework started in " + (System.currentTimeMillis() - this.startTime) / 1000L + " sec."));
    }

    protected void invokeInitialize(List<File> bundleFiles) throws Exception {
        Method init = this.frameworkLoaderClass.getMethod("initialize", ClassLoader.class, File.class, List.class, Map.class);
        init.invoke(null, this.cl, this.homeDir, bundleFiles, this.env);
    }

    protected void invokeStart() throws Exception {
        Method start = this.frameworkLoaderClass.getMethod("start", new Class[0]);
        start.invoke(null, new Object[0]);
    }

    protected void invokeStop() throws Exception {
        Method stop = this.frameworkLoaderClass.getMethod("stop", new Class[0]);
        stop.invoke(null, new Object[0]);
    }

    protected List<File> getBundles() {
        return this.bundles;
    }
}

