/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jboss.deployer;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.virtual.VirtualFile;

public abstract class AbstractNuxeoDeployer
extends AbstractDeployer {
    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (unit.isTopLevel() && unit instanceof VFSDeploymentUnit) {
            VFSDeploymentUnit du = (VFSDeploymentUnit)unit;
            try {
                VirtualFile file = du.getMetaDataFile("nuxeo-structure.xml");
                if (file != null) {
                    this.doDeploy(du);
                }
            }
            catch (Exception e) {
                throw new DeploymentException((Throwable)e);
            }
        }
    }

    public void undeploy(DeploymentUnit unit) {
        if (unit.isTopLevel() && unit instanceof VFSDeploymentUnit) {
            VFSDeploymentUnit du = (VFSDeploymentUnit)unit;
            try {
                VirtualFile file;
                if (!du.getRoot().isArchive() && (file = du.getMetaDataFile("nuxeo-structure.xml")) != null) {
                    this.doUndeploy(du);
                }
            }
            catch (Exception e) {
                this.log.error((Object)"Failed to stop nuxeo", (Throwable)e);
            }
        }
    }

    protected abstract void doDeploy(VFSDeploymentUnit var1) throws Exception;

    protected void doUndeploy(VFSDeploymentUnit unit) throws Exception {
    }
}

