/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jboss.deployer.structure;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.nuxeo.runtime.jboss.deployer.Utils;
import org.nuxeo.runtime.jboss.deployer.structure.PathPattern;

public class PathMatcher {
    protected final Logger log = Logger.getLogger(this.getClass());
    protected final List<String> exactPaths = new ArrayList<String>();
    protected final Map<String, PathPattern> patterns = new HashMap<String, PathPattern>();

    public List<String> getExactPaths() {
        return this.exactPaths;
    }

    public void addExactPath(String path) {
        this.exactPaths.add(path);
    }

    public void addPattern(String path) {
        int i = path.indexOf(42);
        if (i == -1) {
            this.addExactPath(path);
        } else {
            this.addPattern(PathPattern.parse(path));
        }
    }

    public boolean isEmpty() {
        return this.patterns.isEmpty() && this.exactPaths.isEmpty();
    }

    public PathPattern addPattern(PathPattern pattern) {
        PathPattern existing = this.patterns.get(pattern.getPath());
        if (existing != null) {
            existing.setNext(pattern);
        } else {
            this.patterns.put(pattern.getPath(), pattern);
        }
        return pattern;
    }

    public void addPatterns(String[] paths) {
        if (paths == null) {
            return;
        }
        for (String path : paths) {
            this.addPattern(path);
        }
    }

    public Map<String, PathPattern> getPatterns() {
        return this.patterns;
    }

    public void addPatterns(String pathExpr) {
        String[] ar;
        if (pathExpr == null || pathExpr.length() == 0) {
            return;
        }
        for (String path : ar = Utils.split(pathExpr, ':', true)) {
            this.addPattern(path);
        }
    }

    public List<VirtualFile> getMatches(VirtualFile root) throws IOException {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (String path : this.exactPaths) {
            VirtualFile file = root.getChild(path);
            if (file != null) {
                result.add(file);
                continue;
            }
            this.log.warn((Object)("Path pattern not matched: " + path + " in deployment " + root.getName()));
        }
        for (final PathPattern pattern : this.patterns.values()) {
            VirtualFile dir;
            String path = pattern.getPath();
            VirtualFile virtualFile = dir = path.length() == 0 ? root : root.getChild(path);
            if (dir != null) {
                result.addAll(dir.getChildren(new VirtualFileFilter(){

                    public boolean accepts(VirtualFile file) {
                        return pattern.match(file.getName());
                    }
                }));
                continue;
            }
            this.log.warn((Object)("Path pattern not matched: " + path + " in deployment " + root.getName()));
        }
        return result;
    }

    public List<File> getMatchesAsFiles(File root) throws IOException {
        ArrayList<File> result = new ArrayList<File>();
        for (String path : this.exactPaths) {
            File file = new File(root, path);
            if (file.exists()) {
                result.add(file);
                continue;
            }
            this.log.warn((Object)("Path pattern not matched: " + path + " in deployment " + root.getName()));
        }
        for (PathPattern pattern : this.patterns.values()) {
            String path = pattern.getPath();
            File dir = path.length() == 0 ? root : new File(root, path);
            String[] files = dir.list();
            if (files != null) {
                for (String file : files) {
                    if (!pattern.match(file)) continue;
                    result.add(new File(dir, file));
                }
                continue;
            }
            this.log.warn((Object)("Path pattern not matched: " + path + " in deployment " + root.getName()));
        }
        return result;
    }

    public List<String> getMatchesAsPaths(File root) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        for (String path : this.exactPaths) {
            File file = new File(root, path);
            if (file.exists()) {
                result.add(path);
                continue;
            }
            this.log.warn((Object)("Path pattern not matched: " + path + " in deployment " + root.getName()));
        }
        for (PathPattern pattern : this.patterns.values()) {
            String path = pattern.getPath();
            File dir = path.length() == 0 ? root : new File(root, path);
            String[] files = dir.list();
            if (files != null) {
                for (String file : files) {
                    if (!pattern.match(file)) continue;
                    result.add(path + '/' + file);
                }
                continue;
            }
            this.log.warn((Object)("Path pattern not matched: " + path + " in deployment " + root.getName()));
        }
        return result;
    }

    public List<File> getAbsoluteMatches() throws IOException {
        ArrayList<File> result = new ArrayList<File>();
        for (String path : this.exactPaths) {
            File file = new File(path);
            if (file.exists()) {
                result.add(file);
                continue;
            }
            this.log.warn((Object)("Absolute path pattern not matched: " + path));
        }
        for (PathPattern pattern : this.patterns.values()) {
            String path = pattern.getPath();
            File dir = path.length() == 0 ? new File("/") : new File(path);
            String[] files = dir.list();
            if (files != null) {
                for (String file : files) {
                    if (!pattern.match(file)) continue;
                    result.add(new File(dir, file));
                }
                continue;
            }
            this.log.warn((Object)("Absolute path pattern not matched: " + path));
        }
        return result;
    }
}

