/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jboss.deployer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.util.file.Files;
import org.jboss.util.file.JarUtils;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;

public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);

    private Utils() {
    }

    public static File tryGetFile(URL url) throws Exception {
        String protocol = url.getProtocol().toLowerCase();
        if ("file".equals(protocol)) {
            return Utils.getFile(url);
        }
        if ("jar".equals(protocol)) {
            return Utils.getJarFile(url);
        }
        throw new IOException("URL protocol not known: " + protocol);
    }

    public static File getFile(URL url) throws Exception {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            return new File(url.getPath());
        }
    }

    public static File getJarFile(URL url) throws Exception {
        String path = url.getPath();
        int i = path.indexOf(33);
        if (i > -1) {
            path = path.substring(0, i);
        }
        return Utils.getFile(new URL(path));
    }

    public static File getFile(VirtualFile vf) throws Exception {
        return Utils.tryGetFile(VFSUtils.getRealURL((VirtualFile)vf));
    }

    public static File getRealHomeDir(VirtualFile vf) throws Exception {
        return Utils.getRealHomeDir(vf, 0L);
    }

    public static File getRealHomeDir(VirtualFile vf, long lastModified) throws Exception {
        File file = Utils.getFile(vf);
        if (file.isFile()) {
            return Utils.getZippedHomeDir(file, vf.getName(), lastModified);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static File getZippedHomeDir(File jar, String name, long lastModified) throws Exception {
        String tmpPath = System.getProperty("jboss.server.temp.dir");
        File tmp = new File(tmpPath);
        File homeDir = new File(tmp, "nuxeo/" + name);
        if (homeDir.isDirectory()) {
            if (lastModified > 0L && lastModified < homeDir.lastModified()) {
                return homeDir;
            }
            Files.delete((File)homeDir);
        }
        homeDir.mkdirs();
        try (FileInputStream in = new FileInputStream(jar);){
            double s = System.currentTimeMillis();
            JarUtils.unjar((InputStream)in, (File)homeDir);
            log.info((Object)("Unpacking Nuxeo Application took: " + ((double)System.currentTimeMillis() - s) / 1000.0 + " sec."));
        }
        return homeDir;
    }

    public static String[] split(String str, char delimiter, boolean trim) {
        int s = 0;
        int e = str.indexOf(delimiter, s);
        if (e == -1) {
            if (trim) {
                str = str.trim();
            }
            return new String[]{str};
        }
        ArrayList<String> ar = new ArrayList<String>();
        do {
            String segment = str.substring(s, e);
            if (trim) {
                segment = segment.trim();
            }
            ar.add(segment);
        } while ((e = str.indexOf(delimiter, s = e + 1)) != -1);
        int len = str.length();
        if (s < len) {
            String segment = str.substring(s);
            if (trim) {
                segment = segment.trim();
            }
            ar.add(segment);
        } else {
            ar.add("");
        }
        return ar.toArray(new String[ar.size()]);
    }

    public static String expandVars(String expression, Map<?, ?> properties) {
        int p = expression.indexOf("${");
        if (p == -1) {
            return expression;
        }
        char[] buf = expression.toCharArray();
        StringBuilder result = new StringBuilder(buf.length);
        if (p > 0) {
            result.append(expression.substring(0, p));
        }
        StringBuilder varBuf = new StringBuilder();
        boolean dollar = false;
        boolean var = false;
        block5: for (int i = p; i < buf.length; ++i) {
            char c = buf[i];
            switch (c) {
                case '$': {
                    dollar = true;
                    continue block5;
                }
                case '{': {
                    if (dollar) {
                        dollar = false;
                        var = true;
                        continue block5;
                    }
                    result.append(c);
                    continue block5;
                }
                case '}': {
                    if (var) {
                        var = false;
                        String varName = varBuf.toString();
                        varBuf.setLength(0);
                        Object varValue = properties.get(varName);
                        if (varValue != null) {
                            result.append(varValue.toString());
                            continue block5;
                        }
                        result.append("${").append(varName).append('}');
                        continue block5;
                    }
                    result.append(c);
                    continue block5;
                }
                default: {
                    if (var) {
                        varBuf.append(c);
                        continue block5;
                    }
                    result.append(c);
                }
            }
        }
        return result.toString();
    }
}

