/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jboss.deployer.structure;

import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.virtual.VirtualFile;
import org.nuxeo.runtime.jboss.deployer.Utils;
import org.nuxeo.runtime.jboss.deployer.structure.DeploymentStructure;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DeploymentStructureReader {
    protected static Log log = LogFactory.getLog(DeploymentStructureReader.class);
    protected DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();

    public DeploymentStructure read(VirtualFile vhome, InputStream in) throws Exception {
        String[] ar;
        DeploymentStructure md = new DeploymentStructure(vhome);
        DocumentBuilder docBuilder = this.dbfac.newDocumentBuilder();
        Document doc = docBuilder.parse(in);
        Element root = doc.getDocumentElement();
        Attr attr = root.getAttributeNode("children");
        if (attr != null) {
            ar = Utils.split(attr.getValue().trim(), ':', true);
            md.setChildren(ar);
        }
        if ((attr = root.getAttributeNode("bundles")) != null) {
            ar = Utils.split(attr.getValue().trim(), ':', true);
            md.setBundles(ar);
        }
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName().toLowerCase();
            if ("context".equalsIgnoreCase(name)) {
                this.readContext((Element)node, md);
                continue;
            }
            if ("properties".equals(name)) {
                DeploymentStructureReader.readProperties(vhome, (Element)node, md);
                continue;
            }
            if (!"preprocessor".equals(name)) continue;
            this.readPreprocessor((Element)node, md);
        }
        return md;
    }

    protected void readPreprocessor(Element element, DeploymentStructure md) {
        Attr attr = element.getAttributeNode("enabled");
        String enabled = attr == null ? "true" : attr.getValue().trim();
        md.setRequirePreprocessing(Boolean.parseBoolean(enabled));
        attr = element.getAttributeNode("classpath");
        if (attr != null) {
            String[] ar = Utils.split(attr.getValue().trim(), ':', true);
            md.setPreprocessorClassPath(ar);
        }
    }

    protected void readContext(Element element, DeploymentStructure md) {
        String[] ar;
        Attr attr = element.getAttributeNode("path");
        String path = attr == null ? "" : attr.getValue().trim();
        DeploymentStructure.Context ctx = new DeploymentStructure.Context(path);
        attr = element.getAttributeNode("metaDataPath");
        if (attr != null) {
            ar = Utils.split(attr.getValue().trim(), ':', true);
            ctx.setMetaDataPath(ar);
        }
        if ((attr = element.getAttributeNode("classpath")) != null) {
            ar = Utils.split(attr.getValue().trim(), ':', true);
            ctx.setClasspath(ar);
        }
        md.addContext(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readProperties(VirtualFile file, Element element, DeploymentStructure md) throws Exception {
        Attr attr = element.getAttributeNode("src");
        if (attr != null) {
            VirtualFile vf = file.getChild(attr.getValue().trim());
            if (vf != null) {
                try (InputStream in = vf.openStream();){
                    Properties props = new Properties();
                    props.load(in);
                    md.getProperties().putAll(props);
                }
            } else {
                log.warn((Object)("Properties file referenced in nuxeo-structure.xml could not be found: " + attr.getValue()));
            }
        }
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !child.getNodeName().equalsIgnoreCase("property")) continue;
            Element echild = (Element)child;
            attr = echild.getAttributeNode("name");
            if (attr == null) {
                log.warn((Object)"Invalid property element format in nuxeo-structure.xml. Property name attribute is required");
            }
            md.setProperty(attr.getValue().trim(), echild.getTextContent().trim());
        }
    }
}

