/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.info;

import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.connect.connector.fake.FakeDownloadablePackage;
import org.nuxeo.connect.update.Package;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.Version;
import org.nuxeo.launcher.info.PackageInfo;

public class PackageInfoTest {
    static final Log log = LogFactory.getLog(PackageInfoTest.class);
    private PackageInfo packageInfo1;

    @Before
    public void setup() {
        FakeDownloadablePackage pkg = new FakeDownloadablePackage("test", new Version("1.0.0"));
        this.packageInfo1 = new PackageInfo((Package)pkg);
    }

    @Test
    public void testMarshalling() throws JAXBException, JSONException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{PackageInfo.class});
        StringWriter xml = new StringWriter();
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)this.packageInfo1, (Writer)xml);
        log.debug((Object)((Object)xml).toString());
        JSONObject entity = XML.toJSONObject((String)((Object)xml).toString()).getJSONObject("package");
        Assert.assertEquals((Object)"test", (Object)entity.getString("name"));
        Assert.assertEquals((Object)PackageState.UNKNOWN, (Object)PackageState.getByLabel((String)entity.getString("state")));
        Assert.assertEquals((Object)false, (Object)entity.getBoolean("supportsHotReload"));
        Assert.assertEquals((Object)new Version("1.0.0"), (Object)new Version(entity.getString("version")));
    }
}

