/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.log4j;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;

public class Log4JHelper {
    private static final Log log = LogFactory.getLog(Log4JHelper.class);

    public static List<String> getFileAppendersFileNames(Configuration configuration) {
        ArrayList<String> names = new ArrayList<String>();
        for (Appender appender : configuration.getAppenders().values()) {
            if (appender instanceof FileAppender) {
                names.add(((FileAppender)appender).getFileName());
                continue;
            }
            if (!(appender instanceof RollingFileAppender)) continue;
            names.add(((RollingFileAppender)appender).getFileName());
        }
        return names;
    }

    public static Configuration newConfiguration(File log4jConfigurationFile) {
        if (log4jConfigurationFile == null || !log4jConfigurationFile.exists()) {
            throw new IllegalArgumentException("Missing Log4J configuration: " + log4jConfigurationFile);
        }
        XmlConfiguration configuration = new XmlConfiguration(null, ConfigurationSource.fromUri((URI)log4jConfigurationFile.toURI()));
        configuration.initialize();
        log.debug((Object)("Log4j configuration " + log4jConfigurationFile + " successfully loaded."));
        return configuration;
    }

    public static List<String> getFileAppendersFileNames(File log4jConfigurationFile) {
        return Log4JHelper.getFileAppendersFileNames(Log4JHelper.newConfiguration(log4jConfigurationFile));
    }

    public static void setLevel(String[] loggerNames, Level level, boolean includeChildren) {
        if (includeChildren) {
            LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
            Configuration config = loggerContext.getConfiguration();
            boolean set = false;
            for (String parentLogger : loggerNames) {
                set |= Log4JHelper.setLevel(parentLogger, level, config);
                for (Map.Entry entry : config.getLoggers().entrySet()) {
                    if (!((String)entry.getKey()).startsWith(parentLogger)) continue;
                    set |= Log4JHelper.setLevel((LoggerConfig)entry.getValue(), level);
                }
            }
            if (set) {
                loggerContext.updateLoggers();
            }
        } else {
            Configurator.setLevel(Stream.of(loggerNames).collect(Collectors.toMap(Function.identity(), l -> level)));
        }
    }

    private static boolean setLevel(String loggerName, Level level, Configuration config) {
        boolean set;
        LoggerConfig loggerConfig = config.getLoggerConfig(loggerName);
        if (!loggerName.equals(loggerConfig.getName())) {
            loggerConfig = new LoggerConfig(loggerName, level, true);
            config.addLogger(loggerName, loggerConfig);
            loggerConfig.setLevel(level);
            set = true;
        } else {
            set = Log4JHelper.setLevel(loggerConfig, level);
        }
        return set;
    }

    private static boolean setLevel(LoggerConfig loggerConfig, Level level) {
        boolean set;
        boolean bl = set = !loggerConfig.getLevel().equals((Object)level);
        if (set) {
            loggerConfig.setLevel(level);
        }
        return set;
    }
}

