/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Before;
import org.nuxeo.launcher.config.ConfigurationGenerator;

public abstract class AbstractConfigurationTest {
    static final Log log = LogFactory.getLog(AbstractConfigurationTest.class);
    protected ConfigurationGenerator configGenerator;
    protected File nuxeoHome;
    protected Map<String, String> originSystemProps = new HashMap<String, String>();

    public File getResourceFile(String resource) {
        URL url = this.getClass().getClassLoader().getResource(resource);
        try {
            return new File(URLDecoder.decode(url.getPath(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
            return null;
        }
    }

    @Before
    public void setUp() throws Exception {
        this.nuxeoHome = new File("target/launcher");
        this.nuxeoHome.delete();
        this.nuxeoHome.mkdirs();
        File nuxeoConf = this.getResourceFile("configurator/nuxeo.conf");
        FileUtils.copyFileToDirectory((File)nuxeoConf, (File)this.nuxeoHome);
        this.setSystemProperty("nuxeo.conf", new File(this.nuxeoHome, nuxeoConf.getName()).getPath());
        this.setSystemProperty("nuxeo.home", this.nuxeoHome.getPath());
        this.setSystemProperty("nuxeo.data.dir", new File(this.nuxeoHome, "data").getPath());
        this.setSystemProperty("nuxeo.log.dir", new File(this.nuxeoHome, "log").getPath());
    }

    @After
    public void tearDown() throws Exception {
        FileUtils.deleteQuietly((File)this.nuxeoHome);
        this.originSystemProps.forEach((key, value) -> {
            if (value == null) {
                System.clearProperty(key);
            } else {
                System.setProperty(key, value);
            }
        });
        this.originSystemProps.clear();
    }

    protected void setSystemProperty(String key, String newValue) {
        this.originSystemProps.put(key, System.setProperty(key, newValue));
    }
}

