/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.common.codec.Crypto;
import org.nuxeo.common.codec.CryptoProperties;
import org.nuxeo.common.utils.TextTemplate;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.Package;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.info.ConfigurationInfo;
import org.nuxeo.launcher.info.DistributionInfo;
import org.nuxeo.launcher.info.InstanceInfo;
import org.nuxeo.launcher.info.KeyValueInfo;
import org.nuxeo.launcher.info.PackageInfo;
import org.nuxeo.log4j.Log4JHelper;

public class ServerConfigurator {
    private static final Logger log = LogManager.getLogger(ServerConfigurator.class);
    public static final String TOMCAT_STARTUP_CLASS = "org.apache.catalina.startup.Bootstrap";
    public static final String TOMCAT_HOME = "tomcat.home";
    public static final String PARAM_HTTP_TOMCAT_ADMIN_PORT = "nuxeo.server.tomcat_admin.port";
    public static final List<String> NUXEO_SYSTEM_PROPERTIES = List.of("nuxeo.conf", "nuxeo.home", "log.id");
    protected static final String DEFAULT_CONTEXT_NAME = "/nuxeo";
    public static final String JAVA_OPTS = "JAVA_OPTS";
    private static final String NEW_FILES = "templates" + File.separator + "files.list";
    protected final ConfigurationGenerator generator;
    protected File dataDir = null;
    protected File logDir = null;
    protected File pidDir = null;
    protected File tmpDir = null;
    protected File packagesDir = null;
    private String contextName = null;

    public ServerConfigurator(ConfigurationGenerator configurationGenerator) {
        this.generator = configurationGenerator;
    }

    protected boolean isConfigured() {
        Path nuxeoContext = Path.of("conf", "Catalina", "localhost", this.getContextName() + ".xml");
        return Files.exists(this.generator.getNuxeoHome().toPath().resolve(nuxeoContext), new LinkOption[0]);
    }

    public String getContextName() {
        if (this.contextName == null) {
            CryptoProperties userConfig = this.generator.getUserConfig();
            this.contextName = userConfig != null ? userConfig.getProperty("org.nuxeo.ecm.contextPath", DEFAULT_CONTEXT_NAME) : DEFAULT_CONTEXT_NAME;
            this.contextName = this.contextName.substring(1);
        }
        return this.contextName;
    }

    protected void parseAndCopy(Properties config) throws IOException, TemplateException, ConfigurationException {
        String nuxeoEnvironmentConf = this.generator.getNuxeoEnvironmentConfName();
        FilenameFilter filter = (dir, name) -> !"nuxeo.defaults".equals(name) && !nuxeoEnvironmentConf.equals(name);
        TextTemplate templateParser = new TextTemplate(config);
        templateParser.setKeepEncryptedAsVar(true);
        templateParser.setTrim(true);
        templateParser.setTextParsingExtensions(config.getProperty("nuxeo.plaintext_parsing_extensions", "xml,properties,nx"));
        templateParser.setFreemarkerParsingExtensions(config.getProperty("nuxeo.freemarker_parsing_extensions", "nxftl"));
        this.deleteTemplateFiles();
        ArrayList<String> newFilesList = new ArrayList<String>();
        for (File includedTemplate : this.generator.getIncludedTemplates()) {
            String outputDirectoryStr;
            File[] listFiles = includedTemplate.listFiles(filter);
            if (listFiles == null) continue;
            String templateName = includedTemplate.getName();
            log.debug("Parsing {}... {}", new Supplier[]{() -> templateName, () -> Arrays.toString(listFiles)});
            boolean isDeprecated = Boolean.parseBoolean(config.getProperty(templateName + ".deprecated"));
            if (isDeprecated) {
                log.warn("WARNING: Template {} is deprecated.", (Object)templateName);
                String deprecationMessage = config.getProperty(templateName + ".deprecation");
                if (deprecationMessage != null) {
                    log.warn(deprecationMessage);
                }
            }
            File outputDirectory = (outputDirectoryStr = config.getProperty(templateName + ".target")) != null ? new File(this.generator.getNuxeoHome(), outputDirectoryStr) : this.getOutputDirectory();
            for (File in : listFiles) {
                newFilesList.addAll(templateParser.processDirectory(in, new File(outputDirectory, in.getName())));
            }
        }
        this.storeNewFilesList(newFilesList);
    }

    private void deleteTemplateFiles() throws IOException, ConfigurationException {
        File newFiles = new File(this.generator.getNuxeoHome(), NEW_FILES);
        if (!newFiles.exists()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(newFiles));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.endsWith(".bak")) {
                    log.debug("Restore {}", (Object)line);
                    String originalName = line.substring(0, line.length() - 4);
                    try {
                        File backup = new File(this.generator.getNuxeoHome(), line);
                        File original = new File(this.generator.getNuxeoHome(), originalName);
                        FileUtils.copyFile((File)backup, (File)original);
                        backup.delete();
                        continue;
                    }
                    catch (IOException e) {
                        throw new ConfigurationException(String.format("Failed to restore %s from %s\nEdit or delete %s to bypass that error.", originalName, line, newFiles), e);
                    }
                }
                log.debug("Remove {}", (Object)line);
                new File(this.generator.getNuxeoHome(), line).delete();
            }
        }
        newFiles.delete();
    }

    private void storeNewFilesList(List<String> newFilesList) throws IOException {
        File newFiles = new File(this.generator.getNuxeoHome(), NEW_FILES);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newFiles, false), StandardCharsets.UTF_8));){
            int index = this.generator.getNuxeoHome().getCanonicalPath().length() + 1;
            for (String filepath : newFilesList) {
                writer.write(new File(filepath).getCanonicalPath().substring(index));
                writer.newLine();
            }
        }
    }

    protected File getOutputDirectory() {
        return this.getRuntimeHome();
    }

    protected String getDefaultDataDir() {
        return "nxserver" + File.separator + "data";
    }

    protected File getRuntimeHome() {
        return new File(this.generator.getNuxeoHome(), "nxserver");
    }

    public File getDataDir() {
        if (this.dataDir == null) {
            this.dataDir = new File(this.generator.getNuxeoHome(), this.getDefaultDataDir());
        }
        return this.dataDir;
    }

    public File getLogDir() {
        if (this.logDir == null) {
            this.logDir = new File(this.generator.getNuxeoHome(), "log");
        }
        return this.logDir;
    }

    public void setDataDir(String dataDirStr) {
        this.dataDir = new File(dataDirStr);
        this.dataDir.mkdirs();
    }

    public void setLogDir(String logDirStr) {
        this.logDir = new File(logDirStr);
        this.logDir.mkdirs();
    }

    public void initLogs() {
        File logFile = this.getLogConfFile();
        String logDirectory = System.getProperty("nuxeo.log.dir");
        if (logDirectory == null) {
            System.setProperty("nuxeo.log.dir", this.getLogDir().getPath());
        }
        if (logFile == null || !logFile.exists()) {
            System.out.println("No logs configuration, will setup a basic one.");
            Configurator.initialize((Configuration)new DefaultConfiguration());
        } else {
            System.out.println("Try to configure logs with " + logFile);
            Configurator.initialize((Configuration)Log4JHelper.newConfiguration(logFile));
        }
        log.info("Logs successfully configured.");
    }

    public File getPidDir() {
        if (this.pidDir == null) {
            this.pidDir = this.getLogDir();
        }
        return this.pidDir;
    }

    public void setPidDir(String pidDirStr) {
        this.pidDir = new File(pidDirStr);
        this.pidDir.mkdirs();
    }

    public void checkPaths() throws ConfigurationException {
        File oldPackagesPath;
        File badInstanceClid = new File(this.generator.getNuxeoHome(), this.getDefaultDataDir() + File.separator + "instance.clid");
        if (badInstanceClid.exists() && !this.getDataDir().equals(badInstanceClid.getParentFile())) {
            log.warn("Moving {} to {}.", new Supplier[]{() -> badInstanceClid, this::getDataDir});
            try {
                FileUtils.moveFileToDirectory((File)badInstanceClid, (File)this.getDataDir(), (boolean)true);
            }
            catch (IOException e) {
                throw new ConfigurationException("NXP-6722 move failed: " + e.getMessage(), e);
            }
        }
        if ((oldPackagesPath = new File(this.getDataDir(), this.getDefaultPackagesDir())).exists() && !oldPackagesPath.equals(this.getPackagesDir())) {
            log.warn("NXP-8014 Packages cache location changed. You can safely delete {} or move its content to {}", new Supplier[]{() -> oldPackagesPath, this::getPackagesDir});
        }
    }

    public File getTmpDir() {
        if (this.tmpDir == null) {
            this.tmpDir = new File(this.generator.getNuxeoHome(), this.getDefaultTmpDir());
        }
        return this.tmpDir;
    }

    public String getDefaultTmpDir() {
        return "tmp";
    }

    public void setTmpDir(String tmpDirStr) {
        this.tmpDir = new File(tmpDirStr);
        this.tmpDir.mkdirs();
    }

    public void setDirectory(String key, String directory) {
        String absoluteDirectory = this.setAbsolutePath(key, directory);
        if ("nuxeo.data.dir".equals(key)) {
            this.setDataDir(absoluteDirectory);
        } else if ("nuxeo.log.dir".equals(key)) {
            this.setLogDir(absoluteDirectory);
        } else if ("nuxeo.pid.dir".equals(key)) {
            this.setPidDir(absoluteDirectory);
        } else if ("nuxeo.tmp.dir".equals(key)) {
            this.setTmpDir(absoluteDirectory);
        } else if ("nuxeo.mp.dir".equals(key)) {
            this.setPackagesDir(absoluteDirectory);
        } else {
            log.error("Unknown directory key: {}", (Object)key);
        }
    }

    private void setPackagesDir(String packagesDirStr) {
        this.packagesDir = new File(packagesDirStr);
        this.packagesDir.mkdirs();
    }

    private String setAbsolutePath(String key, String directory) {
        if (!new File(directory).isAbsolute()) {
            directory = new File(this.generator.getNuxeoHome(), directory).getPath();
            this.generator.getUserConfig().setProperty(key, directory);
        }
        return directory;
    }

    public File getDirectory(String key) {
        if ("nuxeo.data.dir".equals(key)) {
            return this.getDataDir();
        }
        if ("nuxeo.log.dir".equals(key)) {
            return this.getLogDir();
        }
        if ("nuxeo.pid.dir".equals(key)) {
            return this.getPidDir();
        }
        if ("nuxeo.tmp.dir".equals(key)) {
            return this.getTmpDir();
        }
        if ("nuxeo.mp.dir".equals(key)) {
            return this.getPackagesDir();
        }
        log.error("Unknown directory key: {}", (Object)key);
        return null;
    }

    protected void checkPath(File oldPath, String message) throws ConfigurationException {
        if (oldPath.exists()) {
            log.error("Deprecated paths used.");
            throw new ConfigurationException(message);
        }
    }

    public File getLogConfFile() {
        return new File(this.getServerLibDir(), "log4j2.xml");
    }

    public File getConfigDir() {
        return new File(this.getRuntimeHome(), "config");
    }

    public void dumpProperties(CryptoProperties userConfig) {
        Properties dumpedProperties = this.filterSystemProperties(userConfig);
        File dumpedFile = this.generator.getDumpedConfig();
        try (OutputStreamWriter os = new OutputStreamWriter((OutputStream)new FileOutputStream(dumpedFile, false), StandardCharsets.UTF_8);){
            dumpedProperties.store(os, "Generated by " + this.getClass());
        }
        catch (FileNotFoundException e) {
            log.error((Object)e);
        }
        catch (IOException e) {
            log.error("Could not dump properties to {}", (Object)dumpedFile, (Object)e);
        }
    }

    public Properties filterSystemProperties(CryptoProperties properties) {
        Properties dumpedProperties = new Properties();
        Enumeration propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = (String)propertyNames.nextElement();
            if (System.getProperties().containsKey(key) && !NUXEO_SYSTEM_PROPERTIES.contains(key)) continue;
            dumpedProperties.setProperty(key, properties.getRawProperty(key));
        }
        return dumpedProperties;
    }

    public File getNuxeoLibDir() {
        return new File(this.getRuntimeHome(), "lib");
    }

    public File getServerLibDir() {
        return new File(this.generator.getNuxeoHome(), "lib");
    }

    public void verifyInstallation() throws ConfigurationException {
        this.checkPaths();
        this.checkNetwork();
    }

    protected void checkNetwork() throws ConfigurationException {
        InetAddress bindAddress = this.generator.getBindAddress();
        ConfigurationGenerator.checkPortAvailable(bindAddress, Integer.parseInt(this.generator.getUserConfig().getProperty(PARAM_HTTP_TOMCAT_ADMIN_PORT)));
    }

    public File getPackagesDir() {
        if (this.packagesDir == null) {
            this.packagesDir = new File(this.generator.getNuxeoHome(), this.getDefaultPackagesDir());
        }
        return this.packagesDir;
    }

    public String getDefaultPackagesDir() {
        return "packages";
    }

    public InstanceInfo getInfo(String clid, List<LocalPackage> pkgs) {
        InstanceInfo nxInstance = new InstanceInfo();
        nxInstance.NUXEO_CONF = this.generator.getNuxeoConf().getPath();
        nxInstance.NUXEO_HOME = this.generator.getNuxeoHome().getPath();
        File distFile = new File(this.generator.getConfigDir(), "distribution.properties");
        if (!distFile.exists()) {
            distFile = new File(this.generator.getNuxeoHome(), "templates");
            distFile = new File(distFile, "common");
            distFile = new File(distFile, "config");
            distFile = new File(distFile, "distribution.properties");
        }
        try {
            nxInstance.distribution = new DistributionInfo(distFile);
        }
        catch (IOException e) {
            nxInstance.distribution = new DistributionInfo();
        }
        nxInstance.clid = clid;
        HashSet<String> pkgTemplates = new HashSet<String>();
        for (LocalPackage pkg : pkgs) {
            PackageInfo info = new PackageInfo((Package)pkg);
            nxInstance.packages.add(info);
            pkgTemplates.addAll(info.templates);
        }
        nxInstance.config = new ConfigurationInfo();
        nxInstance.config.profiles.addAll(Arrays.asList(this.generator.getEnvironment("NUXEO_PROFILES", "").split(",")));
        nxInstance.config.dbtemplate = this.generator.extractDatabaseTemplateName();
        String userTemplates = this.generator.getUserTemplates();
        StringTokenizer st = new StringTokenizer(userTemplates, ",");
        while (st.hasMoreTokens()) {
            String template = st.nextToken();
            if (template.equals(nxInstance.config.dbtemplate)) continue;
            if (pkgTemplates.contains(template)) {
                nxInstance.config.pkgtemplates.add(template);
                continue;
            }
            File testBase = new File(this.generator.getNuxeoHome(), "templates" + File.separator + template);
            if (testBase.exists()) {
                nxInstance.config.basetemplates.add(template);
                continue;
            }
            nxInstance.config.usertemplates.add(template);
        }
        CryptoProperties userConfig = this.generator.getUserConfig();
        for (Object item : new TreeSet(userConfig.keySet())) {
            String key = (String)item;
            String value = userConfig.getRawProperty(key);
            if (JAVA_OPTS.equals(key)) {
                value = this.generator.getJavaOptsString();
            }
            if (ConfigurationGenerator.SECRET_KEYS.contains(key) || key.contains("password") || key.equals("server.status.key") || Crypto.isEncrypted((String)value)) {
                value = "********";
            }
            nxInstance.config.keyvals.add(new KeyValueInfo(key, value));
        }
        return nxInstance;
    }
}

