/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import freemarker.core.ParseException;
import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.common.function.ThrowableConsumer;
import org.nuxeo.common.utils.TextTemplate;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationHolder;

public class ConfigurationMarshaller {
    private static final Logger log = LogManager.getLogger(ConfigurationMarshaller.class);
    protected static final String BOUNDARY_BEGIN = "### BEGIN - DO NOT EDIT BETWEEN BEGIN AND END ###";
    protected static final String BOUNDARY_END = "### END - DO NOT EDIT BETWEEN BEGIN AND END ###";
    protected static final String PROTECTION_COMMENT = "## DO NOT EDIT THIS FILE";
    protected static final String NEW_FILES = "files.list";
    protected static final List<String> NUXEO_SYSTEM_PROPERTIES = List.of("nuxeo.conf", "nuxeo.home", "log.id");
    protected final Properties systemProperties;

    public ConfigurationMarshaller(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public void persistNuxeoConf(ConfigurationHolder configHolder) throws ConfigurationException {
        NuxeoConfContent content = this.readConfiguration(configHolder.getNuxeoConfPath());
        this.editUserConf(content, configHolder);
        this.editConfiguratorConf(content, configHolder);
        this.writeConfiguration(content, configHolder);
    }

    public Map<String, String> persistNuxeoDefaults(Path nuxeoDefaultsPath, Map<String, String> newParametersToSave) throws ConfigurationException {
        NuxeoConfContent content = this.readConfiguration(nuxeoDefaultsPath);
        if (content.lines.stream().anyMatch(l -> l.startsWith(PROTECTION_COMMENT))) {
            throw new ConfigurationException("The template states in its header that it must not be modified.");
        }
        HashMap<String, String> oldValues = new HashMap<String, String>();
        for (String key : newParametersToSave.keySet()) {
            oldValues.put(key, content.properties.get(key));
        }
        ListIterator<String> it = content.lines.listIterator();
        while (it.hasNext()) {
            String key;
            String line2 = it.next();
            int equalIdx = line2.indexOf("=");
            if (equalIdx <= 0 || line2.startsWith("#") || !newParametersToSave.containsKey(key = line2.substring(0, equalIdx))) continue;
            if (newParametersToSave.get(key) == null) {
                it.set("#" + (String)line2);
                continue;
            }
            it.set(key + "=" + newParametersToSave.get(key));
        }
        for (String key : newParametersToSave.keySet()) {
            if (oldValues.containsKey(key)) continue;
            content.lines.add(key + "=" + newParametersToSave.get(key));
        }
        try (BufferedWriter writer = Files.newBufferedWriter(nuxeoDefaultsPath, new OpenOption[0]);){
            content.lines.forEach(ThrowableConsumer.asConsumer(line -> writer.append((CharSequence)line).append(System.lineSeparator())));
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to write to " + nuxeoDefaultsPath, e);
        }
        return oldValues;
    }

    protected NuxeoConfContent readConfiguration(Path nuxeoConfPath) throws ConfigurationException {
        NuxeoConfContent content = new NuxeoConfContent();
        try (DigestInputStream dis = new DigestInputStream(Files.newInputStream(nuxeoConfPath, new OpenOption[0]), DigestUtils.getMd5Digest());
             BufferedReader reader = new BufferedReader(new InputStreamReader(dis));){
            String line;
            boolean onConfiguratorContent = false;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith(BOUNDARY_BEGIN)) {
                    onConfiguratorContent = true;
                    continue;
                }
                if (line.startsWith(BOUNDARY_END)) {
                    onConfiguratorContent = false;
                    continue;
                }
                if (onConfiguratorContent) {
                    content.addConfiguratorLine(line);
                    continue;
                }
                content.addLine(line);
            }
            content.digest = Hex.encodeHexString((byte[])dis.getMessageDigest().digest());
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading:" + nuxeoConfPath, e);
        }
        return content;
    }

    protected void editUserConf(NuxeoConfContent content, ConfigurationHolder configHolder) {
        int i;
        Integer generationIndex = null;
        Integer templatesIndex = null;
        String generationParam = configHolder.getProperty("nuxeo.force.generation");
        String templatesParam = configHolder.getProperty("nuxeo.templates");
        ListIterator<String> it = content.lines.listIterator();
        while ((i = it.nextIndex()) != content.lines.size()) {
            String key;
            Object line = it.next();
            if (((String)line).startsWith("nuxeo.force.generation")) {
                if (generationParam != null) {
                    line = "nuxeo.force.generation=" + generationParam;
                }
                if (generationIndex == null) {
                    generationIndex = i;
                } else {
                    it.remove();
                }
                content.lines.set(generationIndex, (String)line);
                continue;
            }
            if (((String)line).startsWith("nuxeo.templates")) {
                if (templatesParam != null) {
                    line = "nuxeo.templates=" + templatesParam;
                }
                if (templatesIndex == null) {
                    templatesIndex = i;
                } else {
                    it.remove();
                }
                content.lines.set(templatesIndex, (String)line);
                continue;
            }
            int equalIdx = ((String)line).indexOf(61);
            if (equalIdx <= 0 || ((String)line).startsWith("#") || configHolder.getProperty(key = ((String)line).substring(0, equalIdx).trim()) != null) continue;
            content.lines.set(i, "#" + (String)line);
            content.properties.remove(key);
        }
        if (templatesIndex == null) {
            content.lines.add("nuxeo.templates=" + (String)StringUtils.defaultIfBlank((CharSequence)templatesParam, (CharSequence)"default"));
        }
    }

    protected void editConfiguratorConf(NuxeoConfContent content, ConfigurationHolder configHolder) {
        content.configuratorProperties.entrySet().removeIf(e -> ((String)e.getValue()).equals(configHolder.getRawProperty((String)e.getKey())));
    }

    protected void writeConfiguration(NuxeoConfContent content, ConfigurationHolder configHolder) throws ConfigurationException {
        block26: {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 DigestOutputStream dos = new DigestOutputStream(baos, DigestUtils.getMd5Digest());
                 OutputStreamWriter writer = new OutputStreamWriter(dos);){
                content.lines.forEach(ThrowableConsumer.asConsumer(line -> writer.append((CharSequence)line).append(System.lineSeparator())));
                if (StringUtils.isNotBlank((CharSequence)content.lines.get(content.lines.size() - 1))) {
                    writer.append(System.lineSeparator());
                }
                writer.append(BOUNDARY_BEGIN).append(System.lineSeparator());
                for (String key : new TreeSet<String>(configHolder.keySet())) {
                    if ("nuxeo.force.generation".equals(key) || "nuxeo.templates".equals(key)) continue;
                    String userValue = content.properties.get(key);
                    String generatorValue = content.configuratorProperties.get(key);
                    String valueToSet = StringUtils.trimToEmpty((String)configHolder.getRawProperty(key));
                    if (content.properties.containsKey(key) && valueToSet.equals(userValue)) continue;
                    if (generatorValue != null) {
                        writer.append("#").append(key).append("=").append(generatorValue).append(System.lineSeparator());
                    }
                    writer.append(key).append("=").append(valueToSet).append(System.lineSeparator());
                }
                writer.append(BOUNDARY_END).append(System.lineSeparator());
                writer.flush();
                if (Hex.encodeHexString((byte[])dos.getMessageDigest().digest()).equals(content.digest)) break block26;
                try (OutputStream os = Files.newOutputStream(configHolder.getNuxeoConfPath(), new OpenOption[0]);){
                    baos.writeTo(os);
                }
            }
            catch (IOException e) {
                throw new ConfigurationException("Error writing: " + configHolder.getNuxeoConfPath(), e);
            }
        }
    }

    public void dumpConfiguration(ConfigurationHolder configHolder) throws ConfigurationException {
        try {
            this.parseAndCopy(configHolder);
            this.dumpProperties(configHolder);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Missing file: " + e.getMessage(), e);
        }
        catch (ParseException | TemplateException e) {
            throw new ConfigurationException("Could not process FreeMarker template: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Configuration failure: " + e.getMessage(), e);
        }
    }

    protected void parseAndCopy(ConfigurationHolder configHolder) throws IOException, TemplateException, ConfigurationException {
        FilenameFilter filter = (dir, name) -> !"nuxeo.defaults".equals(name) && (!name.startsWith("nuxeo.") || !Files.exists(dir.toPath().resolve("nuxeo.defaults"), new LinkOption[0]));
        TextTemplate templateParser = this.instantiateTemplateParser(configHolder);
        this.deleteTemplateFiles(configHolder);
        ArrayList<String> newFilesList = new ArrayList<String>();
        for (Path includedTemplate : configHolder.getIncludedTemplates()) {
            File[] listFiles = includedTemplate.toFile().listFiles(filter);
            if (listFiles == null) continue;
            String templateName = includedTemplate.getFileName().toString();
            log.debug("Parsing template: {}... files: {}", new Supplier[]{() -> templateName, () -> Arrays.toString(listFiles)});
            if (configHolder.getPropertyAsBoolean(templateName + ".deprecated")) {
                log.warn("WARNING: Template {} is deprecated.", (Object)templateName);
                configHolder.getOptProperty(templateName + ".deprecation").ifPresent(arg_0 -> ((Logger)log).warn(arg_0));
            }
            Path out = configHolder.getOptProperty(templateName + ".target").map(configHolder.getHomePath()::resolve).orElseGet(configHolder::getRuntimeHomePath);
            for (File in : listFiles) {
                newFilesList.addAll(templateParser.processDirectory(in, out.resolve(in.getName()).toFile()));
            }
        }
        this.storeNewFilesList(configHolder, newFilesList);
    }

    protected TextTemplate instantiateTemplateParser(ConfigurationHolder configHolder) {
        TextTemplate templateParser = new TextTemplate((Properties)configHolder.userConfig);
        templateParser.setKeepEncryptedAsVar(true);
        templateParser.setTrim(true);
        templateParser.setTextParsingExtensions(configHolder.getProperty("nuxeo.plaintext_parsing_extensions", "xml,properties,nx"));
        templateParser.setFreemarkerParsingExtensions(configHolder.getProperty("nuxeo.freemarker_parsing_extensions", "nxftl"));
        return templateParser;
    }

    protected void deleteTemplateFiles(ConfigurationHolder configHolder) throws IOException, ConfigurationException {
        Path newFiles = configHolder.getTemplatesPath().resolve(NEW_FILES);
        if (Files.notExists(newFiles, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(newFiles);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.endsWith(".bak")) {
                    log.debug("Restore {}", (Object)line);
                    String originalName = line.substring(0, line.length() - 4);
                    try {
                        Path backup = configHolder.getHomePath().resolve(line);
                        Path original = configHolder.getHomePath().resolve(originalName);
                        Files.copy(backup, original, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                        Files.delete(backup);
                        continue;
                    }
                    catch (IOException e) {
                        throw new ConfigurationException(String.format("Failed to restore %s from %s\nEdit or delete %s to bypass that error.", originalName, line, newFiles), e);
                    }
                }
                log.debug("Remove {}", (Object)line);
                Files.deleteIfExists(configHolder.getHomePath().resolve(line));
            }
        }
        Files.delete(newFiles);
    }

    protected void storeNewFilesList(ConfigurationHolder configHolder, List<String> newFilesList) throws IOException {
        Path newFiles = configHolder.getTemplatesPath().resolve(NEW_FILES);
        try (BufferedWriter writer = Files.newBufferedWriter(newFiles, StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            for (String filepath : newFilesList) {
                writer.write(configHolder.getHomePath().relativize(Path.of(filepath, new String[0])).normalize().toString());
                writer.newLine();
            }
        }
    }

    protected void dumpProperties(ConfigurationHolder configHolder) {
        Properties properties = configHolder.stringPropertyNames().stream().sorted().filter(k -> this.systemProperties.getProperty((String)k) == null || NUXEO_SYSTEM_PROPERTIES.contains(k)).collect(Collectors.toMap(Function.identity(), configHolder::getRawProperty, (v1, v2) -> v2, Properties::new));
        Path dumpedFile = configHolder.getDumpedConfigurationPath();
        try {
            Files.createDirectories(dumpedFile.getParent(), new FileAttribute[0]);
            try (BufferedWriter os = Files.newBufferedWriter(dumpedFile, StandardCharsets.UTF_8, new OpenOption[0]);){
                properties.store(os, "Generated by " + this.getClass());
            }
        }
        catch (IOException e) {
            log.error("Could not dump properties to {}", (Object)dumpedFile, (Object)e);
        }
    }

    protected static class NuxeoConfContent {
        protected List<String> lines = new ArrayList<String>();
        protected Map<String, String> properties = new HashMap<String, String>();
        protected Map<String, String> configuratorProperties = new HashMap<String, String>();
        protected String digest;

        protected NuxeoConfContent() {
        }

        public void addLine(String line) {
            this.lines.add(line);
            int equalIdx = line.indexOf(61);
            if (equalIdx > 0 && !line.startsWith("#")) {
                String key = line.substring(0, equalIdx).trim();
                String value = line.substring(equalIdx + 1).trim();
                this.properties.put(key, value);
            }
        }

        public void addConfiguratorLine(String line) {
            boolean wanted = !line.startsWith("#nuxeo.templates") && !line.startsWith("nuxeo.templates");
            int equalIdx = line.indexOf(61);
            if (wanted &= equalIdx > 0) {
                String key = line.startsWith("#") ? line.substring(1, equalIdx).trim() : line.substring(0, equalIdx).trim();
                String value = line.substring(equalIdx + 1).trim();
                this.configuratorProperties.put(key, value);
            }
        }
    }
}

