/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.NullEnumeration;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.JBossConfigurator;
import org.nuxeo.launcher.config.JettyConfigurator;
import org.nuxeo.launcher.config.ServerConfigurator;
import org.nuxeo.launcher.config.TomcatConfigurator;
import org.nuxeo.log4j.Log4JHelper;

public class ConfigurationGenerator {
    private static final Log log = LogFactory.getLog(ConfigurationGenerator.class);
    public static final String NUXEO_HOME = "nuxeo.home";
    public static final String NUXEO_CONF = "nuxeo.conf";
    protected static final String TEMPLATES = "templates";
    protected static final String NUXEO_DEFAULT_CONF = "nuxeo.defaults";
    @Deprecated
    public static final String PARAM_TEMPLATE_NAME = "nuxeo.template";
    public static final String PARAM_TEMPLATES_NAME = "nuxeo.templates";
    public static final String PARAM_TEMPLATE_DBNAME = "nuxeo.dbtemplate";
    public static final String PARAM_TEMPLATES_NODB = "nuxeo.nodbtemplates";
    public static final String PARAM_TEMPLATES_PARSING_EXTENSIONS = "nuxeo.templates.parsing.extensions";
    protected static final String PARAM_INCLUDED_TEMPLATES = "nuxeo.template.includes";
    public static final String PARAM_FORCE_GENERATION = "nuxeo.force.generation";
    public static final String BOUNDARY_BEGIN = "### BEGIN - DO NOT EDIT BETWEEN BEGIN AND END ###";
    public static final String BOUNDARY_END = "### END - DO NOT EDIT BETWEEN BEGIN AND END ###";
    public static final List<String> DB_LIST = Arrays.asList("default", "postgresql", "oracle", "mysql", "mssql");
    public static final String PARAM_WIZARD_DONE = "nuxeo.wizard.done";
    public static final String PARAM_WIZARD_RESTART_PARAMS = "wizard.restart.params";
    public static final String PARAM_FAKE_WINDOWS = "org.nuxeo.fake.vindoz";
    public static final String PARAM_LOOPBACK_URL = "nuxeo.loopback.url";
    public static final int MIN_PORT = 1;
    public static final int MAX_PORT = 65535;
    public static final int ADDRESS_PING_TIMEOUT = 1000;
    public static final String PARAM_BIND_ADDRESS = "nuxeo.bind.address";
    public static final String PARAM_HTTP_PORT = "nuxeo.server.http.port";
    public static final String PARAM_STATUS_KEY = "server.status.key";
    public static final String PARAM_CONTEXT_PATH = "org.nuxeo.ecm.contextPath";
    public static final String INSTALL_AFTER_RESTART = "installAfterRestart.log";
    private final File nuxeoHome;
    private final File nuxeoConf;
    private final List<File> includedTemplates = new ArrayList<File>();
    private File nuxeoDefaultConf;
    public boolean isJBoss;
    public boolean isJetty;
    public boolean isTomcat;
    private ServerConfigurator serverConfigurator;
    private boolean forceGeneration;
    private Properties defaultConfig;
    private Properties userConfig;
    private boolean configurable = false;
    private boolean onceGeneration = false;
    private String templates;
    private boolean setOnceToFalse = true;
    private boolean setFalseToOnce = false;

    public boolean isConfigurable() {
        return this.configurable;
    }

    public ConfigurationGenerator() {
        File userDir;
        String nuxeoHomePath = System.getProperty(NUXEO_HOME);
        String nuxeoConfPath = System.getProperty(NUXEO_CONF);
        this.nuxeoHome = nuxeoHomePath != null ? new File(nuxeoHomePath) : ("bin".equalsIgnoreCase((userDir = new File(System.getProperty("user.dir"))).getName()) ? userDir.getParentFile() : userDir);
        this.nuxeoConf = nuxeoConfPath != null ? new File(nuxeoConfPath) : new File(this.nuxeoHome, "bin" + File.separator + NUXEO_CONF);
        this.nuxeoDefaultConf = new File(this.nuxeoHome, TEMPLATES + File.separator + NUXEO_DEFAULT_CONF);
        this.isJBoss = System.getProperty("jboss.home.dir") != null;
        this.isJetty = System.getProperty("jetty.home") != null;
        boolean bl = this.isTomcat = System.getProperty("tomcat.home") != null;
        if (!(this.isJBoss || this.isJetty || this.isTomcat)) {
            String[] files;
            this.isJBoss = new File(this.nuxeoHome, "bin/run.jar").exists();
            this.isTomcat = new File(this.nuxeoHome, "bin/bootstrap.jar").exists();
            for (String file : files = this.nuxeoHome.list()) {
                if (!file.startsWith("nuxeo-runtime-launcher")) continue;
                this.isJetty = true;
                break;
            }
        }
        if (this.isJBoss) {
            this.serverConfigurator = new JBossConfigurator(this);
        } else if (this.isTomcat) {
            this.serverConfigurator = new TomcatConfigurator(this);
        } else if (this.isJetty) {
            this.serverConfigurator = new JettyConfigurator(this);
        }
        if (Logger.getRootLogger().getAllAppenders() instanceof NullEnumeration) {
            this.serverConfigurator.initLogs();
        }
        log.info((Object)("Nuxeo home:          " + this.nuxeoHome.getPath()));
        log.info((Object)("Nuxeo configuration: " + this.nuxeoConf.getPath()));
    }

    public void setForceGeneration(boolean forceGeneration) {
        this.forceGeneration = forceGeneration;
    }

    public boolean isForceGeneration() {
        return this.forceGeneration;
    }

    public Properties getUserConfig() {
        return this.userConfig;
    }

    public final ServerConfigurator getServerConfigurator() {
        return this.serverConfigurator;
    }

    public void run() throws ConfigurationException {
        if (this.init()) {
            if (!this.serverConfigurator.isConfigured()) {
                log.info((Object)"No current configuration, generating files...");
                this.generateFiles();
            } else if (this.forceGeneration) {
                log.info((Object)("Configuration files generation (nuxeo.force.generation=" + this.userConfig.getProperty(PARAM_FORCE_GENERATION, "false") + ")..."));
                this.generateFiles();
            } else {
                log.info((Object)"Server already configured (set nuxeo.force.generation=true to force configuration files generation).");
            }
        }
    }

    public boolean init() {
        if (this.serverConfigurator == null) {
            log.warn((Object)"Unrecognized server. Considered as already configured.");
            this.configurable = false;
        } else if (!this.nuxeoConf.exists()) {
            log.info((Object)("Missing " + this.nuxeoConf));
            this.configurable = false;
        } else if (this.userConfig == null) {
            try {
                this.setBasicConfiguration();
                this.configurable = true;
            }
            catch (ConfigurationException e) {
                log.warn((Object)"Error reading basic configuration.", (Throwable)e);
                this.configurable = false;
            }
        } else {
            this.configurable = true;
        }
        return this.configurable;
    }

    public void changeTemplates(String newTemplates) {
        try {
            this.includedTemplates.clear();
            this.templates = newTemplates;
            this.setBasicConfiguration();
            this.configurable = true;
        }
        catch (ConfigurationException e) {
            log.warn((Object)"Error reading basic configuration.", (Throwable)e);
            this.configurable = false;
        }
    }

    public void changeDBTemplate(String dbTemplate) {
        this.changeTemplates(this.rebuildTemplatesStr(dbTemplate));
    }

    private void setBasicConfiguration() throws ConfigurationException {
        try {
            this.defaultConfig = new Properties();
            this.defaultConfig.load(new FileInputStream(this.nuxeoDefaultConf));
            this.userConfig = new Properties(this.defaultConfig);
            this.userConfig.putAll((Map<?, ?>)System.getProperties());
            if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
                this.replaceBackslashes();
            }
            this.userConfig.load(new FileInputStream(this.nuxeoConf));
            this.onceGeneration = "once".equals(this.userConfig.getProperty(PARAM_FORCE_GENERATION));
            this.forceGeneration = this.onceGeneration || Boolean.parseBoolean(this.userConfig.getProperty(PARAM_FORCE_GENERATION, "false"));
            this.setDirectoryWithProperty("nuxeo.data.dir");
            this.setDirectoryWithProperty("nuxeo.log.dir");
            this.setDirectoryWithProperty("nuxeo.pid.dir");
            this.setDirectoryWithProperty("nuxeo.tmp.dir");
        }
        catch (NullPointerException e) {
            throw new ConfigurationException("Missing file", e);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Missing file: " + this.nuxeoDefaultConf + " or " + this.nuxeoConf, e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading " + this.nuxeoConf, e);
        }
        try {
            if (this.templates == null) {
                this.templates = this.getUserTemplates();
            }
            this.extractDatabaseTemplateName();
            this.includeTemplates(this.templates);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Missing file", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading " + this.nuxeoConf, e);
        }
        HashMap<String, String> newParametersToSave = this.evalDynamicProperties();
        if (newParametersToSave != null && !newParametersToSave.isEmpty()) {
            this.saveConfiguration(newParametersToSave, false, false);
        }
    }

    protected HashMap<String, String> evalDynamicProperties() throws ConfigurationException {
        HashMap<String, String> newParametersToSave = new HashMap<String, String>();
        this.evalLoopbackURL();
        this.evalServerStatusKey(newParametersToSave);
        return newParametersToSave;
    }

    private void evalServerStatusKey(Map<String, String> newParametersToSave) throws ConfigurationException {
        if (this.userConfig.getProperty(PARAM_STATUS_KEY) == null) {
            newParametersToSave.put(PARAM_STATUS_KEY, UUID.randomUUID().toString().substring(0, 8));
        }
    }

    private void evalLoopbackURL() throws ConfigurationException {
        String loopbackURL = this.userConfig.getProperty(PARAM_LOOPBACK_URL);
        if (loopbackURL != null) {
            log.debug((Object)("Using configured loop back url: " + loopbackURL));
            return;
        }
        InetAddress bindAddress = this.getBindAddress();
        try {
            if (bindAddress.isAnyLocalAddress()) {
                boolean preferIPv6 = "false".equals(System.getProperty("java.net.preferIPv4Stack")) && "true".equals(System.getProperty("java.net.preferIPv6Addresses"));
                bindAddress = preferIPv6 ? Inet6Address.getByName("::1") : Inet4Address.getByName("127.0.0.1");
                log.debug((Object)("Bind address is \"ANY\", using local address instead: " + bindAddress));
            }
        }
        catch (UnknownHostException e) {
            log.error((Object)e);
        }
        String httpPort = this.userConfig.getProperty(PARAM_HTTP_PORT);
        String contextPath = this.userConfig.getProperty(PARAM_CONTEXT_PATH);
        loopbackURL = bindAddress instanceof Inet6Address ? "http://[" + bindAddress.getHostAddress() + "]:" + httpPort + contextPath : "http://" + bindAddress.getHostAddress() + ":" + httpPort + contextPath;
        log.debug((Object)("Set as loop back URL: " + loopbackURL));
        this.userConfig.setProperty(PARAM_LOOPBACK_URL, loopbackURL);
    }

    protected void replaceBackslashes() throws ConfigurationException {
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.nuxeoConf));
            while ((line = reader.readLine()) != null) {
                if (line.matches(".*:\\\\.*")) {
                    line = line.replaceAll("\\\\", "/");
                }
                sb.append(line + System.getProperty("line.separator"));
            }
            reader.close();
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading " + this.nuxeoConf, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new ConfigurationException(e);
                }
            }
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.nuxeoConf, false);
            writer.append(sb.toString());
        }
        catch (IOException e) {
            throw new ConfigurationException("Error writing in " + this.nuxeoConf, e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    throw new ConfigurationException(e);
                }
            }
        }
    }

    public void setDirectoryWithProperty(String key) {
        String directory = this.userConfig.getProperty(key);
        if (directory == null) {
            this.userConfig.setProperty(key, this.serverConfigurator.getDirectory(key).getPath());
        } else {
            this.serverConfigurator.setDirectory(key, directory);
        }
    }

    private String getUserTemplates() {
        String userTemplatesList = this.userConfig.getProperty(PARAM_TEMPLATES_NAME);
        if (userTemplatesList == null) {
            userTemplatesList = this.userConfig.getProperty(PARAM_TEMPLATE_NAME);
        }
        if (userTemplatesList == null) {
            log.warn((Object)"No template found in configuration! Fallback on 'default'.");
            userTemplatesList = "default";
        }
        return userTemplatesList;
    }

    protected void generateFiles() throws ConfigurationException {
        try {
            this.serverConfigurator.parseAndCopy(this.userConfig);
            this.serverConfigurator.dumpProperties(this.userConfig);
            log.info((Object)"Configuration files generated.");
            if (this.onceGeneration) {
                this.setOnceToFalse = true;
                this.writeConfiguration(this.loadConfiguration());
            }
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Missing file", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Configuration failure", e);
        }
    }

    private StringBuffer loadConfiguration() throws ConfigurationException {
        return this.loadConfiguration(null);
    }

    private void writeConfiguration(StringBuffer configuration) throws ConfigurationException {
        this.writeConfiguration(configuration, null);
    }

    private void includeTemplates(String templatesList) throws IOException {
        StringTokenizer st = new StringTokenizer(templatesList, ",");
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            File chosenTemplate = new File(nextToken);
            if (!chosenTemplate.exists() || !chosenTemplate.getPath().equals(chosenTemplate.getAbsolutePath())) {
                chosenTemplate = new File(this.nuxeoDefaultConf.getParentFile(), nextToken);
            }
            if (this.includedTemplates.contains(chosenTemplate)) {
                log.debug((Object)("Already included " + nextToken));
                continue;
            }
            if (chosenTemplate.exists()) {
                File chosenTemplateConf = new File(chosenTemplate, NUXEO_DEFAULT_CONF);
                if (chosenTemplateConf.exists()) {
                    Properties subTemplateConf = new Properties();
                    subTemplateConf.load(new FileInputStream(chosenTemplateConf));
                    String subTemplatesList = subTemplateConf.getProperty(PARAM_INCLUDED_TEMPLATES);
                    if (subTemplatesList != null && subTemplatesList.length() > 0) {
                        this.includeTemplates(subTemplatesList);
                    }
                    this.defaultConfig.load(new FileInputStream(chosenTemplateConf));
                    log.info((Object)("Include template: " + chosenTemplate.getPath()));
                } else {
                    log.debug((Object)("No default configuration for template " + nextToken));
                }
                this.includedTemplates.add(chosenTemplate);
                continue;
            }
            log.error((Object)String.format("Template '%s' not found with relative or absolute path (%s). Check your %s parameter, and %s for included files.", nextToken, chosenTemplate, PARAM_TEMPLATES_NAME, PARAM_INCLUDED_TEMPLATES));
        }
    }

    public File getNuxeoHome() {
        return this.nuxeoHome;
    }

    public File getNuxeoDefaultConf() {
        return this.nuxeoDefaultConf;
    }

    public List<File> getIncludedTemplates() {
        return this.includedTemplates;
    }

    public static void main(String[] args) throws ConfigurationException {
        new ConfigurationGenerator().run();
    }

    public void saveConfiguration(Map<String, String> changedParameters) throws ConfigurationException {
        this.saveConfiguration(changedParameters, false, true);
    }

    public void saveConfiguration(Map<String, String> changedParameters, boolean setGenerationOnceToFalse, boolean setGenerationFalseToOnce) throws ConfigurationException {
        this.setOnceToFalse = setGenerationOnceToFalse;
        this.setFalseToOnce = setGenerationFalseToOnce;
        this.writeConfiguration(this.loadConfiguration(changedParameters), changedParameters);
        for (String key : changedParameters.keySet()) {
            if (changedParameters.get(key) == null) continue;
            this.userConfig.setProperty(key, changedParameters.get(key));
        }
    }

    public void saveFilteredConfiguration(Map<String, String> changedParameters) throws ConfigurationException {
        String newDbTemplate = changedParameters.remove(PARAM_TEMPLATE_DBNAME);
        if (newDbTemplate != null) {
            changedParameters.put(PARAM_TEMPLATES_NAME, this.rebuildTemplatesStr(newDbTemplate));
        }
        this.saveConfiguration(this.getChangedParameters(changedParameters));
    }

    public Map<String, String> getChangedParameters(Map<String, String> changedParameters) {
        HashMap<String, String> filteredChangedParameters = new HashMap<String, String>();
        for (String key : changedParameters.keySet()) {
            String oldParam = this.userConfig.getProperty(key);
            String newParam = changedParameters.get(key);
            if (newParam != null) {
                newParam = newParam.trim();
            }
            if ((oldParam != null || newParam == null || newParam.isEmpty()) && (oldParam == null || oldParam.trim().equals(newParam))) continue;
            filteredChangedParameters.put(key, newParam);
        }
        return filteredChangedParameters;
    }

    private void writeConfiguration(StringBuffer newContent, Map<String, String> changedParameters) throws ConfigurationException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.nuxeoConf, false);
            writer.append(newContent.toString());
            if (changedParameters != null && !changedParameters.isEmpty()) {
                writer.write("### BEGIN - DO NOT EDIT BETWEEN BEGIN AND END ### " + new Date().toString() + System.getProperty("line.separator"));
                for (String key : changedParameters.keySet()) {
                    writer.write("#" + key + "=" + this.userConfig.getProperty(key, "") + System.getProperty("line.separator"));
                    if (changedParameters.get(key) == null) continue;
                    writer.write(key + "=" + changedParameters.get(key) + System.getProperty("line.separator"));
                }
                writer.write(BOUNDARY_END + System.getProperty("line.separator"));
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Error writing in " + this.nuxeoConf, e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    throw new ConfigurationException(e);
                }
            }
        }
    }

    private StringBuffer loadConfiguration(Map<String, String> changedParameters) throws ConfigurationException {
        String wizardParam = null;
        String templatesParam = null;
        Integer generationIndex = null;
        Integer wizardIndex = null;
        Integer templatesIndex = null;
        if (changedParameters != null) {
            wizardParam = changedParameters.remove(PARAM_WIZARD_DONE);
            templatesParam = changedParameters.remove(PARAM_TEMPLATES_NAME);
        }
        ArrayList<String> newLines = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.nuxeoConf));
            boolean onConfiguratorContent = false;
            while ((line = reader.readLine()) != null) {
                if (!onConfiguratorContent) {
                    if (!line.startsWith(BOUNDARY_BEGIN)) {
                        if (line.startsWith(PARAM_FORCE_GENERATION)) {
                            if (this.setOnceToFalse && this.onceGeneration) {
                                line = "nuxeo.force.generation=false";
                            }
                            if (this.setFalseToOnce && !this.forceGeneration) {
                                line = "nuxeo.force.generation=once";
                            }
                            if (generationIndex == null) {
                                newLines.add(line);
                                generationIndex = newLines.size() - 1;
                                continue;
                            }
                            newLines.set(generationIndex, line);
                            continue;
                        }
                        if (line.startsWith(PARAM_WIZARD_DONE)) {
                            if (wizardParam != null) {
                                line = "nuxeo.wizard.done=" + wizardParam;
                            }
                            if (wizardIndex == null) {
                                newLines.add(line);
                                wizardIndex = newLines.size() - 1;
                                continue;
                            }
                            newLines.set(wizardIndex, line);
                            continue;
                        }
                        if (line.startsWith(PARAM_TEMPLATES_NAME)) {
                            if (templatesParam != null) {
                                line = "nuxeo.templates=" + templatesParam;
                            }
                            if (templatesIndex == null) {
                                newLines.add(line);
                                templatesIndex = newLines.size() - 1;
                                continue;
                            }
                            newLines.set(templatesIndex, line);
                            continue;
                        }
                        newLines.add(line);
                        continue;
                    }
                    if (templatesIndex == null && templatesParam != null) {
                        newLines.add("nuxeo.templates=" + templatesParam);
                        templatesIndex = newLines.size() - 1;
                    }
                    if (wizardIndex == null && wizardParam != null) {
                        newLines.add("nuxeo.wizard.done=" + wizardParam);
                        wizardIndex = newLines.size() - 1;
                    }
                    onConfiguratorContent = true;
                    continue;
                }
                if (!line.startsWith(BOUNDARY_END)) {
                    String value;
                    String key;
                    if (changedParameters == null) {
                        newLines.add(line);
                        continue;
                    }
                    int equalIdx = line.indexOf("=");
                    if (line.startsWith("#nuxeo.templates") || line.startsWith(PARAM_TEMPLATES_NAME)) continue;
                    if (line.trim().startsWith("#")) {
                        key = line.substring(1, equalIdx).trim();
                        value = line.substring(equalIdx + 1).trim();
                        this.userConfig.setProperty(key, value);
                        continue;
                    }
                    key = line.substring(0, equalIdx).trim();
                    value = line.substring(equalIdx + 1).trim();
                    if (!changedParameters.containsKey(key)) {
                        changedParameters.put(key, value);
                        continue;
                    }
                    if (value.equals(changedParameters.get(key))) continue;
                    this.userConfig.setProperty(key, value);
                    continue;
                }
                onConfiguratorContent = false;
            }
            reader.close();
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading " + this.nuxeoConf, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new ConfigurationException(e);
                }
            }
        }
        StringBuffer newContent = new StringBuffer();
        for (int i = 0; i < newLines.size(); ++i) {
            newContent.append(((String)newLines.get(i)).trim() + System.getProperty("line.separator"));
        }
        return newContent;
    }

    public String extractDatabaseTemplateName() {
        String dbTemplate = "unknown";
        String nodbTemplates = "";
        StringTokenizer st = new StringTokenizer(this.templates, ",");
        while (st.hasMoreTokens()) {
            String template = st.nextToken();
            if (DB_LIST.contains(template)) {
                dbTemplate = template;
                continue;
            }
            nodbTemplates = nodbTemplates + template;
        }
        this.userConfig.put(PARAM_TEMPLATES_NODB, nodbTemplates);
        this.userConfig.put(PARAM_TEMPLATE_DBNAME, dbTemplate);
        return dbTemplate;
    }

    public File getNuxeoConf() {
        return this.nuxeoConf;
    }

    public void initLogs() {
        this.serverConfigurator.initLogs();
    }

    public File getLogDir() {
        return this.serverConfigurator.getLogDir();
    }

    public File getPidDir() {
        return this.serverConfigurator.getPidDir();
    }

    public File getDataDir() {
        return this.serverConfigurator.getDataDir();
    }

    public void verifyInstallation() throws ConfigurationException {
        String version = System.getProperty("java.version");
        if (!version.startsWith("1.6") && !version.startsWith("1.7")) {
            String message = "Nuxeo requires Java 6 or 7 (detected " + version + ").";
            if ("nofail".equalsIgnoreCase(System.getProperty("jvmcheck", "fail"))) {
                log.error((Object)message);
            } else {
                throw new ConfigurationException(message);
            }
        }
        this.ifNotExistsAndIsDirectoryThenCreate(this.getLogDir());
        this.ifNotExistsAndIsDirectoryThenCreate(this.getPidDir());
        this.ifNotExistsAndIsDirectoryThenCreate(this.getDataDir());
        this.ifNotExistsAndIsDirectoryThenCreate(this.getTmpDir());
        this.serverConfigurator.checkPaths();
        this.serverConfigurator.removeExistingLocks();
        this.checkAddressesAndPorts();
    }

    public void checkAddressesAndPorts() throws ConfigurationException {
        InetAddress bindAddress = this.getBindAddress();
        if (bindAddress.isMulticastAddress()) {
            throw new ConfigurationException("Multicast address won't work: " + bindAddress);
        }
        ConfigurationGenerator.checkAddressReachable(bindAddress);
        ConfigurationGenerator.checkPortAvailable(bindAddress, Integer.parseInt(this.userConfig.getProperty(PARAM_HTTP_PORT)));
    }

    private InetAddress getBindAddress() throws ConfigurationException {
        InetAddress bindAddress;
        try {
            bindAddress = InetAddress.getByName(this.userConfig.getProperty(PARAM_BIND_ADDRESS));
            log.debug((Object)("Configured bind address: " + bindAddress));
        }
        catch (UnknownHostException e) {
            throw new ConfigurationException(e);
        }
        return bindAddress;
    }

    public static void checkAddressReachable(InetAddress address) throws ConfigurationException {
        try {
            log.debug((Object)("Checking availability of " + address));
            address.isReachable(1000);
        }
        catch (IOException e) {
            throw new ConfigurationException("Unreachable bind address " + address);
        }
    }

    public static void checkPortAvailable(InetAddress address, int port) throws ConfigurationException {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        ServerSocket socketTCP = null;
        try {
            log.debug((Object)("Checking availability of port " + port + " on address " + address));
            socketTCP = new ServerSocket(port, 0, address);
            socketTCP.setReuseAddress(true);
        }
        catch (IOException e) {
            throw new ConfigurationException("Port is unavailable: " + port + " on address " + address + " (" + e.getMessage() + ")", e);
        }
        finally {
            if (socketTCP != null) {
                try {
                    socketTCP.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public File getTmpDir() {
        return this.serverConfigurator.getTmpDir();
    }

    private void ifNotExistsAndIsDirectoryThenCreate(File directory) {
        if (!directory.isDirectory()) {
            directory.mkdirs();
        }
    }

    public ArrayList<String> getLogFiles() {
        File log4jConfFile = this.serverConfigurator.getLogConfFile();
        System.setProperty("nuxeo.log.dir", this.getLogDir().getPath());
        return Log4JHelper.getFileAppendersFiles(log4jConfFile);
    }

    public boolean isWizardRequired() {
        return !"true".equalsIgnoreCase(this.getUserConfig().getProperty(PARAM_WIZARD_DONE, "true")) && this.serverConfigurator.isWizardAvailable();
    }

    public String rebuildTemplatesStr(String dbTemplate) {
        String nodbTemplates = this.userConfig.getProperty(PARAM_TEMPLATES_NODB);
        if (nodbTemplates == null) {
            this.extractDatabaseTemplateName();
            nodbTemplates = this.userConfig.getProperty(PARAM_TEMPLATES_NODB);
        }
        String newTemplates = nodbTemplates.isEmpty() ? dbTemplate : dbTemplate + "," + nodbTemplates;
        return newTemplates;
    }

    public File getConfigDir() {
        return this.serverConfigurator.getConfigDir();
    }

    public void prepareWizardStart() {
        this.serverConfigurator.prepareWizardStart();
    }

    public void cleanupPostWizard() {
        this.serverConfigurator.cleanupPostWizard();
    }

    public File getRuntimeHome() {
        return this.serverConfigurator.getRuntimeHome();
    }

    public boolean isInstallInProgress() {
        return this.getInstallFile().exists();
    }

    public File getInstallFile() {
        return new File(this.serverConfigurator.getDataDir(), INSTALL_AFTER_RESTART);
    }

    public void addTemplate(String template) throws ConfigurationException {
        HashMap<String, String> newParametersToSave = new HashMap<String, String>();
        String oldTemplates = this.userConfig.getProperty(PARAM_TEMPLATES_NAME);
        String[] oldTemplatesSplit = oldTemplates.split(",");
        if (!Arrays.asList(oldTemplatesSplit).contains(template)) {
            String newTemplates = oldTemplates + (oldTemplates.length() > 0 ? "," : "") + template;
            newParametersToSave.put(PARAM_TEMPLATES_NAME, newTemplates);
            this.saveFilteredConfiguration(newParametersToSave);
            this.changeTemplates(newTemplates);
        }
    }

    public void rmTemplate(String template) throws ConfigurationException {
        HashMap<String, String> newParametersToSave = new HashMap<String, String>();
        String oldTemplates = this.userConfig.getProperty(PARAM_TEMPLATES_NAME);
        List<String> oldTemplatesSplit = Arrays.asList(oldTemplates.split(","));
        if (oldTemplatesSplit.contains(template)) {
            String newTemplates = "";
            boolean firstIem = true;
            for (String templateItem : oldTemplatesSplit) {
                if (template.equals(templateItem)) continue;
                newTemplates = newTemplates + (firstIem ? "" : ",") + templateItem;
                firstIem = false;
            }
            newParametersToSave.put(PARAM_TEMPLATES_NAME, newTemplates);
            this.saveFilteredConfiguration(newParametersToSave);
            this.changeTemplates(newTemplates);
        }
    }

    public String setProperty(String key, String value) throws ConfigurationException {
        HashMap<String, String> newParametersToSave = new HashMap<String, String>();
        newParametersToSave.put(key, value);
        String oldValue = this.userConfig.getProperty(key);
        this.saveFilteredConfiguration(newParametersToSave);
        this.setBasicConfiguration();
        return oldValue;
    }
}

