/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.commons.text;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class TextTemplate {
    private static final Pattern PATTERN = Pattern.compile("\\$\\{([a-zA-Z_0-9\\-\\.]+)\\}");
    private final Properties vars;
    private boolean trim = false;
    private List<String> extensions;
    private boolean extensionsContainsDot = false;

    public boolean isTrim() {
        return this.trim;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public TextTemplate() {
        this.vars = new Properties();
    }

    @Deprecated
    public TextTemplate(Map<String, String> vars) {
        this.vars = new Properties();
        this.vars.putAll(vars);
    }

    public TextTemplate(Properties vars) {
        this.vars = vars;
    }

    @Deprecated
    public void setVariables(Map<String, String> vars) {
        this.vars.putAll(vars);
    }

    public void setVariable(String name, String value) {
        this.vars.setProperty(name, value);
    }

    public String getVariable(String name) {
        return this.vars.getProperty(name);
    }

    public Properties getVariables() {
        return this.vars;
    }

    public String process(CharSequence text) {
        Matcher m = PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String var = m.group(1);
            String value = this.getVariable(var);
            if (value == null) continue;
            if (this.trim) {
                value = value.trim();
            }
            String oldValue = value;
            while (!(value = this.process(oldValue)).equals(oldValue)) {
                oldValue = value;
            }
            String valueL = Matcher.quoteReplacement(value);
            m.appendReplacement(sb, valueL);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public String process(InputStream in) throws IOException {
        String text = IOUtils.toString((InputStream)in, (String)"UTF-8");
        return this.process(text);
    }

    public void process(InputStream in, OutputStream out) throws IOException {
        this.process(in, out, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDirectory(File in, File out) throws FileNotFoundException, IOException {
        if (in.isFile()) {
            if (out.isDirectory()) {
                out = new File(out, in.getName());
            }
            if (!out.getParentFile().exists()) {
                out.getParentFile().mkdirs();
            }
            boolean processText = false;
            if (!this.extensionsContainsDot) {
                int extIndex = in.getName().lastIndexOf(46);
                String extension = extIndex == -1 ? "" : in.getName().substring(extIndex + 1).toLowerCase();
                processText = this.extensions == null || this.extensions.contains(extension);
            } else {
                String filename = in.getName().toLowerCase();
                for (String ext : this.extensions) {
                    if (!filename.endsWith(ext)) continue;
                    processText = true;
                    break;
                }
            }
            FileInputStream is = null;
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(out);
                is = new FileInputStream(in);
                this.process(is, os, processText);
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
        } else if (in.isDirectory()) {
            if (!out.exists()) {
                out.mkdirs();
            } else if (!out.getName().equals(in.getName())) {
                out = new File(out, in.getName());
                out.mkdir();
            }
            for (File file : in.listFiles()) {
                this.processDirectory(file, out);
            }
        }
    }

    public void process(InputStream is, OutputStream os, boolean processText) throws IOException {
        if (processText) {
            String text = IOUtils.toString((InputStream)is, (String)"UTF-8");
            text = this.process(text);
            os.write(text.getBytes("UTF-8"));
        } else {
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
    }

    public void setParsingExtensions(String extensionsList) {
        StringTokenizer st = new StringTokenizer(extensionsList, ",");
        this.extensions = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String extension = st.nextToken();
            this.extensions.add(extension);
            if (this.extensionsContainsDot || !extension.contains(".")) continue;
            this.extensionsContainsDot = true;
        }
    }
}

