/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.info;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.nuxeo.launcher.info.MessageInfo;

public class MessageInfoLogger {
    private List<MessageInfo> messages = new ArrayList<MessageInfo>();

    public List<MessageInfo> getMessages() {
        return this.messages;
    }

    public void printMessages() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
        for (MessageInfo message : this.messages) {
            System.out.println("[" + dateFormat.format(message.time) + "] " + message.level.toString() + " " + message.message);
        }
    }

    public void log(String msg, MessageInfo.LOG_LEVEL level) {
        MessageInfo message = new MessageInfo();
        message.time = new Date();
        message.level = level;
        message.message = msg;
        this.messages.add(message);
    }

    public void debug(Object ... args) {
        for (Object arg : args) {
            if (arg instanceof String) {
                this.debug((String)arg);
                continue;
            }
            if (arg instanceof Throwable) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter stackWriter = new PrintWriter(stringWriter);
                ((Throwable)arg).printStackTrace(stackWriter);
                this.debug(((Object)stringWriter).toString());
                continue;
            }
            this.debug(arg.toString());
        }
    }

    public void debug(String msg) {
        this.log(msg, MessageInfo.LOG_LEVEL.DEBUG);
    }

    public void info(Object ... args) {
        for (Object arg : args) {
            if (arg instanceof String) {
                this.info((String)arg);
                continue;
            }
            if (arg instanceof Throwable) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter stackWriter = new PrintWriter(stringWriter);
                ((Throwable)arg).printStackTrace(stackWriter);
                this.info(((Object)stringWriter).toString());
                continue;
            }
            this.info(arg.toString());
        }
    }

    public void info(String msg) {
        this.log(msg, MessageInfo.LOG_LEVEL.INFO);
    }

    public void warn(Object ... args) {
        for (Object arg : args) {
            if (arg instanceof String) {
                this.warn((String)arg);
                continue;
            }
            if (arg instanceof Throwable) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter stackWriter = new PrintWriter(stringWriter);
                ((Throwable)arg).printStackTrace(stackWriter);
                this.warn(((Object)stringWriter).toString());
                continue;
            }
            this.warn(arg.toString());
        }
    }

    public void warn(String msg) {
        this.log(msg, MessageInfo.LOG_LEVEL.WARN);
    }

    public void error(Object ... args) {
        for (Object arg : args) {
            if (arg instanceof String) {
                this.error((String)arg);
                continue;
            }
            if (arg instanceof Throwable) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter stackWriter = new PrintWriter(stringWriter);
                ((Throwable)arg).printStackTrace(stackWriter);
                this.error(((Object)stringWriter).toString());
                continue;
            }
            this.error(arg.toString());
        }
    }

    public void error(String msg) {
        this.log(msg, MessageInfo.LOG_LEVEL.ERROR);
    }
}

