/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.log4j;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadedStreamGobbler
extends Thread {
    static final Log log = LogFactory.getLog(ThreadedStreamGobbler.class);
    private InputStream is;
    private int logLevel;
    private List<String> output;
    private OutputStream outputStream;

    public ThreadedStreamGobbler(InputStream is, int logLevel) {
        this.is = is;
        this.logLevel = logLevel;
        this.setDaemon(true);
    }

    public ThreadedStreamGobbler(InputStream inputStream, List<String> output) {
        this(inputStream, 7);
        this.output = output;
    }

    public ThreadedStreamGobbler(InputStream inputStream, OutputStream output) {
        this(inputStream, 7);
        this.outputStream = output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BufferedReader br = new BufferedReader(new InputStreamReader(this.is));
        byte[] newLine = "\n".getBytes();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                switch (this.logLevel) {
                    case 2: {
                        log.debug((Object)line);
                        break;
                    }
                    case 3: {
                        log.info((Object)line);
                        break;
                    }
                    case 5: {
                        log.error((Object)line);
                        break;
                    }
                    case 7: {
                        if (this.output != null) {
                            this.output.add(line);
                        }
                        if (this.outputStream == null) break;
                        this.outputStream.write(line.getBytes());
                        this.outputStream.write(newLine);
                    }
                }
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        finally {
            IOUtils.closeQuietly((Reader)br);
        }
    }
}

