/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.runtime.aws.AWSConfigurationDescriptor;
import org.nuxeo.runtime.aws.AWSConfigurationService;
import org.nuxeo.runtime.model.DefaultComponent;

public class AWSConfigurationServiceImpl
extends DefaultComponent
implements AWSConfigurationService {
    public static final String XP_CONFIGURATION = "configuration";

    protected AWSConfigurationDescriptor getDescriptor(String id) {
        return this.getRegistryContribution(XP_CONFIGURATION, id).orElse(null);
    }

    @Override
    public AWSCredentials getAWSCredentials(String id) {
        AWSConfigurationDescriptor descriptor;
        if (id == null) {
            id = "default";
        }
        if ((descriptor = this.getDescriptor(id)) != null) {
            String accessKeyId = descriptor.getAccessKeyId();
            String secretKey = descriptor.getSecretKey();
            String sessionToken = descriptor.getSessionToken();
            if (StringUtils.isNotBlank((CharSequence)accessKeyId) && StringUtils.isNotBlank((CharSequence)secretKey)) {
                if (StringUtils.isNotBlank((CharSequence)sessionToken)) {
                    return new BasicSessionCredentials(accessKeyId, secretKey, sessionToken);
                }
                return new BasicAWSCredentials(accessKeyId, secretKey);
            }
        }
        return null;
    }

    @Override
    public String getAWSRegion(String id) {
        String region;
        AWSConfigurationDescriptor descriptor;
        if (id == null) {
            id = "default";
        }
        if ((descriptor = this.getDescriptor(id)) != null && StringUtils.isNotBlank((CharSequence)(region = descriptor.getRegion()))) {
            return region;
        }
        return null;
    }
}

