/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.cluster;

import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.cluster.ClusterNodeDescriptor;
import org.nuxeo.runtime.cluster.ClusterService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class ClusterServiceImpl
extends DefaultComponent
implements ClusterService {
    private static final Logger log = LogManager.getLogger(ClusterServiceImpl.class);
    public static final int APPLICATION_STARTED_ORDER = -1000;
    public static final String XP_CONFIG = "configuration";
    public static final String CLUSTERING_ENABLED_OLD_PROP = "repository.clustering.enabled";
    public static final String NODE_ID_OLD_PROP = "repository.clustering.id";
    protected static final Random RANDOM = new Random();
    protected boolean enabled;
    protected String nodeId;

    public int getApplicationStartedOrder() {
        return -1000;
    }

    public void start(ComponentContext context) {
        String id;
        ClusterNodeDescriptor descr = (ClusterNodeDescriptor)this.getDescriptor(XP_CONFIG, "");
        Boolean enabledProp = descr == null ? null : descr.getEnabled();
        this.enabled = enabledProp != null ? enabledProp : Framework.isBooleanPropertyTrue((String)CLUSTERING_ENABLED_OLD_PROP);
        String string = id = descr == null ? null : (String)StringUtils.defaultIfBlank((CharSequence)descr.getName(), null);
        if (id != null) {
            this.nodeId = id.trim();
        } else {
            id = Framework.getProperty((String)NODE_ID_OLD_PROP);
            if (StringUtils.isNotBlank((CharSequence)id)) {
                this.nodeId = id.trim();
            } else {
                long l;
                while ((l = RANDOM.nextLong()) < 0L) {
                }
                this.nodeId = String.valueOf(l);
                if (this.enabled) {
                    log.warn("Missing cluster node id configuration, please define it explicitly. Using random cluster node id instead: {}", (Object)this.nodeId);
                } else {
                    log.info("Using random cluster node id: {}", (Object)this.nodeId);
                }
            }
        }
        super.start(context);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        if (!Framework.isTestModeSet()) {
            throw new UnsupportedOperationException("test mode only");
        }
        this.nodeId = nodeId;
    }
}

