/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource;

import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.datasource.PooledDataSourceRegistry;
import org.nuxeo.runtime.jtajca.NuxeoContainer;

public class DataSourceHelper {
    private DataSourceHelper() {
    }

    public static String getDataSourceJNDIPrefix() {
        return NuxeoContainer.nameOf((String)"jdbc");
    }

    public static String getDataSourceJNDIName(String name) {
        return NuxeoContainer.nameOf((String)DataSourceHelper.relativize(name));
    }

    protected static String relativize(String name) {
        int idx = name.lastIndexOf("/");
        if (idx > 0) {
            name = name.substring(idx + 1);
        }
        return "jdbc/".concat(name);
    }

    public static DataSource getDataSource(String partialName) throws NamingException {
        return DataSourceHelper.getDataSource(partialName, DataSource.class);
    }

    public static XADataSource getXADataSource(String partialName) throws NamingException {
        return DataSourceHelper.getDataSource(partialName, XADataSource.class);
    }

    public static <T> T getDataSource(String name, Class<T> clazz) throws NamingException {
        PooledDataSourceRegistry pools = (PooledDataSourceRegistry)Framework.getService(PooledDataSourceRegistry.class);
        if (pools == null) {
            throw new NamingException("runtime datasource no installed");
        }
        T ds = pools.getPool(DataSourceHelper.relativize(name), clazz);
        if (ds == null) {
            return (T)NuxeoContainer.lookup((String)name, clazz);
        }
        return ds;
    }

    public static Map<String, DataSource> getDatasources() throws NamingException {
        String prefix = DataSourceHelper.getDataSourceJNDIPrefix();
        Context naming = NuxeoContainer.getRootContext();
        if (naming == null) {
            throw new NamingException("No root context");
        }
        Context jdbc = (Context)naming.lookup(prefix);
        NamingEnumeration<NameClassPair> namesPair = jdbc.list("");
        HashMap<String, DataSource> datasourcesByName = new HashMap<String, DataSource>();
        while (namesPair.hasMoreElements()) {
            Object ds;
            NameClassPair pair = (NameClassPair)namesPair.nextElement();
            Object name = pair.getName();
            if (pair.isRelative()) {
                name = prefix + "/" + (String)name;
            }
            if (!((ds = naming.lookup((String)name)) instanceof DataSource)) continue;
            datasourcesByName.put((String)name, (DataSource)ds);
        }
        return datasourcesByName;
    }
}

