/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource;

import java.util.HashMap;
import java.util.Map;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.NotContextException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.datasource.DataSourceDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class DataSourceComponent
extends DefaultComponent {
    private final Log log = LogFactory.getLog(DataSourceComponent.class);
    public static final String DATASOURCES_XP = "datasources";
    public static final String ENV_CTX_NAME = "java:comp/env";
    protected final Map<String, DataSourceDescriptor> datasources = new HashMap<String, DataSourceDescriptor>();
    protected boolean started = false;

    public void registerContribution(Object contrib, String extensionPoint, ComponentInstance component) throws Exception {
        if (DATASOURCES_XP.equals(extensionPoint)) {
            if (contrib instanceof DataSourceDescriptor) {
                this.addDataSource((DataSourceDescriptor)contrib);
            } else {
                this.log.error((Object)("Invalid datasource contribution: " + contrib.getClass().getName()));
            }
        } else {
            this.log.error((Object)("Ignoring unknown extension point: " + extensionPoint));
        }
    }

    public void unregisterContribution(Object contrib, String extensionPoint, ComponentInstance component) throws Exception {
        if (DATASOURCES_XP.equals(extensionPoint)) {
            if (contrib instanceof DataSourceDescriptor) {
                this.removeDataSource((DataSourceDescriptor)contrib);
            } else {
                this.log.error((Object)("Invalid datasource contribution: " + contrib.getClass().getName()));
            }
        } else {
            this.log.error((Object)("Ignoring unknown extension point: " + extensionPoint));
        }
    }

    public int getApplicationStartedOrder() {
        return 0;
    }

    public void applicationStarted(ComponentContext context) throws Exception {
        this.started = true;
        for (DataSourceDescriptor datasourceDesc : this.datasources.values()) {
            this.bindDataSource(datasourceDesc);
        }
    }

    public void deactivate(ComponentContext context) throws Exception {
        super.deactivate(context);
        for (DataSourceDescriptor desc : this.datasources.values()) {
            this.log.warn((Object)(desc.name + " datasource still referenced"));
            this.unbindDataSource(desc);
        }
        this.datasources.clear();
        this.started = false;
    }

    protected void addDataSource(DataSourceDescriptor contrib) {
        this.datasources.put(contrib.name, contrib);
        this.bindDataSource(contrib);
    }

    protected void removeDataSource(DataSourceDescriptor contrib) {
        this.unbindDataSource(contrib);
        this.datasources.remove(contrib.name);
    }

    protected void bindDataSource(DataSourceDescriptor descr) {
        if (!this.started) {
            return;
        }
        this.log.info((Object)("Registering datasource: " + descr.name));
        try {
            CompositeName name = new CompositeName("java:comp/env/" + descr.name);
            Context ctx = new InitialContext();
            for (int i = 0; i < name.size() - 1; ++i) {
                try {
                    ctx = (Context)ctx.lookup(name.get(i));
                    continue;
                }
                catch (NamingException e) {
                    ctx = ctx.createSubcontext(name.get(i));
                }
            }
            ctx.bind(name.get(name.size() - 1), (Object)descr.getReference());
        }
        catch (NamingException e) {
            this.log.error((Object)("Cannot bind datasource '" + descr.name + "' in JNDI"), (Throwable)e);
        }
    }

    protected void unbindDataSource(DataSourceDescriptor descr) {
        if (!this.started) {
            return;
        }
        this.log.info((Object)("Unregistering datasource: " + descr.name));
        try {
            InitialContext ctx = new InitialContext();
            ctx.unbind("java:comp/env/" + descr.name);
        }
        catch (NotContextException e) {
            this.log.warn((Object)e);
        }
        catch (NoInitialContextException e) {
        }
        catch (NamingException e) {
            this.log.error((Object)("Cannot unbind datasource '" + descr.name + "' in JNDI"), (Throwable)e);
        }
    }
}

