/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource;

import java.lang.reflect.Field;
import java.sql.SQLException;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.managed.BasicManagedDataSource;
import org.apache.commons.dbcp.managed.LocalXAConnectionFactory;
import org.apache.commons.dbcp.managed.TransactionRegistry;
import org.apache.commons.dbcp.managed.XAConnectionFactory;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.nuxeo.runtime.datasource.PatchedDataSourceXAConnectionFactory;
import org.nuxeo.runtime.datasource.PatchedPoolableManagedConnectionFactory;

public class PatchedBasicManagedDataSource
extends BasicManagedDataSource {
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected ConnectionFactory createConnectionFactory() throws SQLException {
        TransactionManager transactionManager = this.getTransactionManager();
        String xaDataSource = this.getXADataSource();
        XADataSource xaDataSourceInstance = this.getXaDataSourceInstance();
        if (transactionManager == null) {
            throw new SQLException("Transaction manager must be set before a connection can be created");
        }
        if (xaDataSource == null) {
            ConnectionFactory connectionFactory = super.createConnectionFactory();
            LocalXAConnectionFactory xaConnectionFactory = new LocalXAConnectionFactory(this.getTransactionManager(), connectionFactory);
            this.setTransactionRegistry(xaConnectionFactory.getTransactionRegistry());
            return xaConnectionFactory;
        }
        if (xaDataSourceInstance == null) {
            Class<?> xaDataSourceClass = null;
            try {
                xaDataSourceClass = Class.forName(xaDataSource);
            }
            catch (ClassNotFoundException t) {
                String message = "Cannot load XA data source class '" + xaDataSource + "'";
                throw new SQLException(message, t);
            }
            try {
                xaDataSourceInstance = (XADataSource)xaDataSourceClass.newInstance();
            }
            catch (InstantiationException t) {
                String message = "Cannot create XA data source of class '" + xaDataSource + "'";
                throw new SQLException(message, t);
            }
            catch (IllegalAccessException t) {
                String message = "Cannot create XA data source of class '" + xaDataSource + "'";
                throw new SQLException(message, t);
            }
        }
        PatchedDataSourceXAConnectionFactory xaConnectionFactory = new PatchedDataSourceXAConnectionFactory(transactionManager, xaDataSourceInstance, this.username, this.password);
        this.setTransactionRegistry(xaConnectionFactory.getTransactionRegistry());
        return xaConnectionFactory;
    }

    protected void setTransactionRegistry(TransactionRegistry transactionRegistry) {
        try {
            Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("transactionRegistry");
            field.setAccessible(true);
            field.set((Object)this, transactionRegistry);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected void createPoolableConnectionFactory(ConnectionFactory driverConnectionFactory, KeyedObjectPoolFactory statementPoolFactory, AbandonedConfig abandonedConfig) throws SQLException {
        try {
            PatchedPoolableManagedConnectionFactory connectionFactory = new PatchedPoolableManagedConnectionFactory((XAConnectionFactory)driverConnectionFactory, (ObjectPool)this.connectionPool, statementPoolFactory, this.validationQuery, this.validationQueryTimeout, this.connectionInitSqls, this.defaultReadOnly, this.defaultAutoCommit, this.defaultTransactionIsolation, this.defaultCatalog, abandonedConfig);
            PatchedBasicManagedDataSource.validateConnectionFactory((PoolableConnectionFactory)connectionFactory);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw (SQLException)new SQLException("Cannot create PoolableConnectionFactory (" + e.getMessage() + ")").initCause(e);
        }
    }
}

