/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource.geronimo;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.XADataSource;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.datasource.DataSourceHelper;
import org.nuxeo.runtime.datasource.PooledDataSourceRegistry;
import org.nuxeo.runtime.jtajca.NuxeoConnectionManagerConfiguration;
import org.nuxeo.runtime.jtajca.NuxeoConnectionManagerFactory;
import org.nuxeo.runtime.jtajca.NuxeoContainer;
import org.tranql.connector.jdbc.JDBCDriverMCF;
import org.tranql.connector.jdbc.LocalDataSourceWrapper;
import org.tranql.connector.jdbc.TranqlDataSource;
import org.tranql.connector.jdbc.XADataSourceWrapper;

public class PooledDataSourceFactory
implements PooledDataSourceRegistry.Factory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        ManagedConnectionFactory mcf = this.createFactory(ref, ctx);
        NuxeoContainer.ConnectionManagerWrapper cm = this.createManager(ref, ctx);
        return new DataSource(mcf, cm);
    }

    protected NuxeoContainer.ConnectionManagerWrapper createManager(Reference ref, Context ctx) throws ResourceException {
        NuxeoConnectionManagerConfiguration config = NuxeoConnectionManagerFactory.getConfig((Reference)ref);
        String className = ref.getClassName();
        config.setXAMode(XADataSource.class.getName().equals(className));
        return NuxeoContainer.initConnectionManager((NuxeoConnectionManagerConfiguration)config);
    }

    protected ManagedConnectionFactory createFactory(Reference ref, Context ctx) throws NamingException, InvalidPropertyException {
        String className = ref.getClassName();
        if (XADataSource.class.getName().equals(className)) {
            String user = this.refAttribute(ref, "User", "");
            String password = this.refAttribute(ref, "Password", "");
            String name = this.refAttribute(ref, "dataSourceJNDI", null);
            XADataSource ds = (XADataSource)((Object)DataSourceHelper.getDataSource(name));
            XADataSourceWrapper wrapper = new XADataSourceWrapper(ds);
            wrapper.setUserName(user);
            wrapper.setPassword(password);
            return wrapper;
        }
        if (javax.sql.DataSource.class.getName().equals(className)) {
            String user = this.refAttribute(ref, "username", "");
            if (user.isEmpty() && !(user = this.refAttribute(ref, "user", "")).isEmpty()) {
                LogFactory.getLog(PooledDataSourceFactory.class).warn((Object)"wrong attribute 'user' in datasource descriptor, should use 'username' instead");
            }
            String password = this.refAttribute(ref, "password", "");
            String dsname = this.refAttribute(ref, "dataSourceJNDI", "");
            if (!dsname.isEmpty()) {
                javax.sql.DataSource ds = DataSourceHelper.getDataSource(dsname);
                LocalDataSourceWrapper wrapper = new LocalDataSourceWrapper(ds);
                wrapper.setUserName(user);
                wrapper.setPassword(password);
                return wrapper;
            }
            String name = this.refAttribute(ref, "driverClassName", null);
            String url = this.refAttribute(ref, "url", null);
            boolean commitBeforeAutocommit = Boolean.valueOf(this.refAttribute(ref, "commitBeforeAutocommit", "true"));
            JDBCDriverMCF factory = new JDBCDriverMCF();
            factory.setDriver(name);
            factory.setUserName(user);
            factory.setPassword(password);
            factory.setConnectionURL(url);
            factory.setCommitBeforeAutocommit(Boolean.valueOf(commitBeforeAutocommit));
            return factory;
        }
        throw new IllegalArgumentException("unsupported class " + className);
    }

    protected String refAttribute(Reference ref, String key, String defvalue) {
        RefAddr addr = ref.get(key);
        if (addr == null) {
            if (defvalue == null) {
                throw new IllegalArgumentException(key + " address is mandatory");
            }
            return defvalue;
        }
        return (String)addr.getContent();
    }

    protected static class DataSource
    extends TranqlDataSource
    implements PooledDataSourceRegistry.PooledDataSource {
        protected NuxeoContainer.ConnectionManagerWrapper wrapper;

        public DataSource(ManagedConnectionFactory mcf, NuxeoContainer.ConnectionManagerWrapper wrapper) {
            super(mcf, (ConnectionManager)wrapper);
            this.wrapper = wrapper;
        }

        @Override
        public void dispose() throws Exception {
            this.wrapper.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Connection getConnection(boolean noSharing) throws SQLException {
            if (!noSharing) {
                return this.getConnection();
            }
            this.wrapper.enterNoSharing();
            try {
                Connection connection = this.getConnection();
                return connection;
            }
            finally {
                this.wrapper.exitNoSharing();
            }
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException("not yet available");
        }
    }
}

