/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment.preprocessor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.deployment.preprocessor.ConfigurationException;
import org.nuxeo.runtime.deployment.preprocessor.JBossConfigurator;
import org.nuxeo.runtime.deployment.preprocessor.JettyConfigurator;
import org.nuxeo.runtime.deployment.preprocessor.ServerConfigurator;
import org.nuxeo.runtime.deployment.preprocessor.TomcatConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationGenerator {
    private static final Log log = LogFactory.getLog(ConfigurationGenerator.class);
    public static final String NUXEO_HOME = "nuxeo.home";
    public static final String NUXEO_CONF = "nuxeo.conf";
    protected static final String TEMPLATES = "templates";
    protected static final String NUXEO_DEFAULT_CONF = "nuxeo.defaults";
    protected static final String PARAM_TEMPLATE_NAME = "nuxeo.template";
    protected static final String PARAM_TEMPLATES_NAME = "nuxeo.templates";
    protected static final String PARAM_INCLUDED_TEMPLATES = "nuxeo.template.includes";
    protected static final String PARAM_FORCE_GENERATION = "nuxeo.force.generation";
    private File nuxeoHome;
    private File nuxeoConf;
    private File nuxeoDefaultConf;
    private List<File> includedTemplates = new ArrayList<File>();
    private boolean isJBoss;
    private boolean isJetty;
    private boolean isTomcat;
    private ServerConfigurator serverConfigurator;
    private boolean forceGeneration;
    private Properties defaultConfig;
    private Properties userConfig = null;

    public void setForceGeneration(boolean forceGeneration) {
        this.forceGeneration = forceGeneration;
    }

    public Properties getUserConfig() {
        return this.userConfig;
    }

    public ConfigurationGenerator() {
        String nuxeoHomePath = System.getProperty(NUXEO_HOME);
        String nuxeoConfPath = System.getProperty(NUXEO_CONF);
        if (nuxeoHomePath != null && nuxeoConfPath != null) {
            this.nuxeoHome = new File(nuxeoHomePath);
            this.nuxeoConf = new File(nuxeoConfPath);
            this.nuxeoDefaultConf = new File(this.getNuxeoHome(), TEMPLATES + File.separator + NUXEO_DEFAULT_CONF);
        } else {
            this.nuxeoHome = new File(System.getProperty("user.dir")).getParentFile();
            this.nuxeoConf = new File(this.nuxeoHome, "bin" + File.separator + NUXEO_CONF);
        }
        this.isJBoss = System.getProperty("jboss.home.dir") != null;
        this.isJetty = System.getProperty("jetty.home") != null;
        boolean bl = this.isTomcat = System.getProperty("tomcat.home") != null;
        if (!(this.isJBoss || this.isJetty || this.isTomcat)) {
            String[] files;
            this.isJBoss = new File(this.getNuxeoHome(), "bin/run.jar").exists();
            this.isTomcat = new File(this.getNuxeoHome(), "bin/bootstrap.jar").exists();
            for (String file : files = this.getNuxeoHome().list()) {
                if (!file.startsWith("nuxeo-runtime-launcher")) continue;
                this.isJetty = true;
                break;
            }
        }
        if (this.isJBoss) {
            this.serverConfigurator = new JBossConfigurator(this);
        } else if (this.isTomcat) {
            this.serverConfigurator = new TomcatConfigurator(this);
        } else if (this.isJetty) {
            this.serverConfigurator = new JettyConfigurator(this);
        }
    }

    public void run() throws ConfigurationException {
        if (this.userConfig == null) {
            try {
                this.setBasicConfiguration();
            }
            catch (ConfigurationException e) {
                log.warn((Object)"Error reading basic configuration. Server is considered as already configured.");
                log.debug((Object)e);
                return;
            }
        }
        if (this.serverConfigurator == null) {
            log.warn((Object)"Unrecognized server. Considered as already configured.");
        } else if (!this.nuxeoConf.exists()) {
            log.info((Object)("Missing " + this.nuxeoConf));
        } else if (this.forceGeneration) {
            log.info((Object)"Force files generation...");
            this.generateFiles();
            log.info((Object)"Configuration files generated.");
        } else if (this.serverConfigurator.isConfigured()) {
            log.info((Object)"Server already configured");
        } else {
            log.info((Object)"No current configuration, generating files...");
            this.generateFiles();
            log.info((Object)"Configuration files generated.");
        }
    }

    private void setBasicConfiguration() throws ConfigurationException {
        try {
            this.defaultConfig = new Properties();
            this.defaultConfig.load(new FileInputStream(this.getNuxeoDefaultConf()));
            this.userConfig = new Properties(this.defaultConfig);
            this.userConfig.load(new FileInputStream(this.nuxeoConf));
            this.forceGeneration = Boolean.parseBoolean(this.userConfig.getProperty(PARAM_FORCE_GENERATION, "false"));
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Missing file", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading " + this.nuxeoConf, e);
        }
    }

    protected void generateFiles() throws ConfigurationException {
        try {
            this.browseTemplates();
            log.debug((Object)("Loaded configuration: " + this.userConfig));
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Missing file", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading " + this.nuxeoConf, e);
        }
        try {
            this.serverConfigurator.parseAndCopy(this.userConfig);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Missing file", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Configuration failure", e);
        }
    }

    protected void browseTemplates() throws FileNotFoundException, IOException, ConfigurationException {
        String userTemplatesList;
        if (this.userConfig == null) {
            this.setBasicConfiguration();
        }
        if ((userTemplatesList = this.userConfig.getProperty(PARAM_TEMPLATES_NAME)) == null) {
            userTemplatesList = this.userConfig.getProperty(PARAM_TEMPLATE_NAME);
        }
        this.includeTemplates(userTemplatesList);
    }

    private void includeTemplates(String templatesList) throws FileNotFoundException, IOException {
        StringTokenizer st = new StringTokenizer(templatesList, ",");
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            File chosenTemplate = new File(nextToken);
            if (!chosenTemplate.exists()) {
                chosenTemplate = new File(this.getNuxeoDefaultConf().getParentFile(), nextToken);
            }
            if (this.includedTemplates.contains(chosenTemplate)) {
                log.debug((Object)("Aleady included " + nextToken));
                continue;
            }
            if (chosenTemplate.exists()) {
                File chosenTemplateConf = new File(chosenTemplate, NUXEO_DEFAULT_CONF);
                if (chosenTemplateConf.exists()) {
                    Properties subTemplateConf = new Properties();
                    subTemplateConf.load(new FileInputStream(chosenTemplateConf));
                    String subTemplatesList = subTemplateConf.getProperty(PARAM_INCLUDED_TEMPLATES);
                    if (subTemplatesList != null && subTemplatesList.length() > 0) {
                        this.includeTemplates(subTemplatesList);
                    }
                    this.defaultConfig.load(new FileInputStream(chosenTemplateConf));
                    log.debug((Object)("Include " + nextToken));
                } else {
                    log.debug((Object)("No default configuration for template " + nextToken));
                }
                this.includedTemplates.add(chosenTemplate);
                continue;
            }
            log.warn((Object)("No template found neither with absolute (" + nextToken + ") or relative (" + chosenTemplate + ") path! Please check your includes."));
        }
    }

    public File getNuxeoHome() {
        return this.nuxeoHome;
    }

    public File getNuxeoDefaultConf() {
        return this.nuxeoDefaultConf;
    }

    public List<File> getIncludedTemplates() {
        return this.includedTemplates;
    }
}

