/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment.preprocessor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.DependencyTree;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.JarUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.runtime.deployment.preprocessor.ConfigurationGenerator;
import org.nuxeo.runtime.deployment.preprocessor.ContainerDescriptor;
import org.nuxeo.runtime.deployment.preprocessor.FragmentDescriptor;
import org.nuxeo.runtime.deployment.preprocessor.TemplateDescriptor;
import org.nuxeo.runtime.deployment.preprocessor.install.CommandContextImpl;
import org.nuxeo.runtime.deployment.preprocessor.template.TemplateContribution;
import org.nuxeo.runtime.deployment.preprocessor.template.TemplateParser;

public class DeploymentPreprocessor {
    public static final String FRAGMENT_FILE = "OSGI-INF/deployment-fragment.xml";
    public static final String CONTAINER_FILE = "OSGI-INF/deployment-container.xml";
    private static final Log log = LogFactory.getLog(DeploymentPreprocessor.class);
    private final File dir;
    private final XMap xmap;
    private ContainerDescriptor root;
    private final Map<String, String> jar2Id = new HashMap<String, String>();

    public DeploymentPreprocessor(File dir) {
        this.dir = dir;
        this.xmap = new XMap();
        this.xmap.register(ContainerDescriptor.class);
        this.xmap.register(FragmentDescriptor.class);
    }

    public String getJarId(String jarName) {
        return this.jar2Id.get(jarName);
    }

    public ContainerDescriptor getRootContainer() {
        return this.root;
    }

    public void init() throws Exception {
        new ConfigurationGenerator().run();
        this.root = this.getContainer(this.dir);
        if (this.root != null) {
            this.init(this.root);
        }
    }

    protected void init(ContainerDescriptor cd) throws Exception {
        if (cd.context == null) {
            cd.context = new CommandContextImpl(cd.directory);
        }
        if (cd.install != null) {
            cd.install.setLogger(log);
            log.info((Object)("Running custom installation for container: " + cd.name));
            cd.install.exec(cd.context);
        }
        if (cd.directories == null || cd.directories.isEmpty()) {
            this.init(cd, this.dir);
        } else {
            for (String dirPath : cd.directories) {
                this.init(cd, new File(this.dir, dirPath));
            }
        }
    }

    protected void init(ContainerDescriptor cd, File dir) throws Exception {
        log.info((Object)("Scanning directory: " + dir.getName()));
        if (!dir.exists()) {
            log.warn((Object)("Directory doesn't exist: " + dir.getPath()));
            return;
        }
        Object[] files = dir.listFiles();
        Arrays.sort(files);
        for (Object file : files) {
            String fileName = ((File)file).getName();
            FragmentDescriptor fd = null;
            if (fileName.endsWith("-fragment.xml")) {
                fd = this.getXMLFragment((File)file);
            } else {
                if (fileName.endsWith("-fragments.xml")) {
                    this.collectXMLFragments(cd, (File)file);
                    continue;
                }
                if (fileName.endsWith(".jar") || fileName.endsWith(".war") || fileName.endsWith(".sar") || fileName.endsWith(".rar")) {
                    fd = ((File)file).isDirectory() ? this.getDirectoryFragment((File)file) : this.getJARFragment((File)file);
                }
            }
            if (fd == null) continue;
            cd.fragments.add(fd);
            fd.fileName = fileName;
            fd.filePath = DeploymentPreprocessor.getRelativeChildPath(cd.directory.getAbsolutePath(), ((File)file).getAbsolutePath());
            if (fd.templates == null) continue;
            for (TemplateDescriptor td : fd.templates.values()) {
                td.baseDir = file;
                cd.templates.put(td.name, td);
            }
        }
    }

    public void predeploy() throws Exception {
        if (this.root != null) {
            DeploymentPreprocessor.predeploy(this.root);
        }
    }

    protected static void predeploy(ContainerDescriptor cd) throws Exception {
        if (cd.context == null) {
            cd.context = new CommandContextImpl(cd.directory);
        }
        for (DependencyTree.Entry<String, FragmentDescriptor> entry : cd.fragments.getResolvedEntries()) {
            FragmentDescriptor fd = (FragmentDescriptor)entry.get();
            cd.context.put("bundle.fileName", fd.filePath);
            cd.context.put("bundle.shortName", fd.fileName);
            cd.context.put("bundle", fd.name);
            if (fd.install != null) {
                fd.install.setLogger(log);
                log.info((Object)("Running custom installation for fragment: " + fd.name));
                fd.install.exec(cd.context);
            }
            if (fd.contributions == null) continue;
            for (TemplateContribution tc : fd.contributions) {
                TemplateDescriptor td = cd.templates.get(tc.getTemplate());
                if (td != null) {
                    if (td.baseDir == null) {
                        td.baseDir = cd.directory;
                    }
                    if (td.template == null) {
                        File file = new File(td.baseDir, td.src);
                        td.template = TemplateParser.parse(file);
                    }
                } else {
                    log.warn((Object)("No template found for deployment fragment:  " + fd.name));
                    continue;
                }
                td.template.update(tc, cd.context);
            }
        }
        for (TemplateDescriptor td : cd.templates.values()) {
            File file;
            if (td.baseDir == null) {
                td.baseDir = cd.directory;
            }
            if (td.template == null && td.isRequired) {
                file = new File(td.baseDir, td.src);
                td.template = TemplateParser.parse(file);
            }
            if (td.template == null) continue;
            file = new File(td.baseDir, td.installPath);
            file.getParentFile().mkdirs();
            FileUtils.writeFile((File)file, (String)td.template.getText());
        }
        for (ContainerDescriptor subCd : cd.subContainers) {
            DeploymentPreprocessor.predeploy(subCd);
        }
    }

    protected FragmentDescriptor getXMLFragment(File file) throws Exception {
        FragmentDescriptor fd = (FragmentDescriptor)this.xmap.load(file.toURL());
        if (fd != null && fd.name == null) {
            fd.name = file.getName();
        }
        return fd;
    }

    protected void collectXMLFragments(ContainerDescriptor cd, File file) throws Exception {
        Object[] result;
        String fileName = file.getName();
        for (Object entry : result = this.xmap.loadAll(file.toURL())) {
            FragmentDescriptor fd = (FragmentDescriptor)entry;
            assert (fd != null);
            if (fd.name == null) {
                log.error((Object)("Invalid fragments file: " + file.getName() + ". Fragments declared in a -fragments.xml file must have names."));
                continue;
            }
            cd.fragments.add(fd);
            fd.fileName = fileName;
            fd.filePath = DeploymentPreprocessor.getRelativeChildPath(cd.directory.getAbsolutePath(), file.getAbsolutePath());
        }
    }

    protected FragmentDescriptor getDirectoryFragment(File directory) throws Exception {
        Manifest mf;
        FragmentDescriptor fd = null;
        File file = new File(directory.getAbsolutePath() + '/' + FRAGMENT_FILE);
        String fileName = directory.getName();
        if (file.isFile()) {
            fd = (FragmentDescriptor)this.xmap.load(file.toURL());
        } else {
            log.warn((Object)("No OSGI-INF/deployment-fragment.xml found in directory:" + directory + " (must exist, must have exact name)"));
        }
        if (fd == null) {
            fd = new FragmentDescriptor();
        }
        if (fd.name == null) {
            fd.name = fileName;
        }
        if ((mf = JarUtils.getManifest((File)directory)) != null) {
            this.processManifest(fd, fileName, mf);
        }
        return fd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FragmentDescriptor getJARFragment(File file) throws Exception {
        FragmentDescriptor fd = null;
        JarFile jar = new JarFile(file);
        ZipEntry ze = jar.getEntry(FRAGMENT_FILE);
        if (ze != null) {
            Manifest mf;
            BufferedInputStream in = new BufferedInputStream(jar.getInputStream(ze));
            try {
                fd = (FragmentDescriptor)this.xmap.load((InputStream)in);
            }
            finally {
                ((InputStream)in).close();
            }
            String fileName = file.getName();
            if (fd == null) {
                fd = new FragmentDescriptor();
            }
            if (fd.name == null) {
                fd.name = fileName;
            }
            if ((mf = JarUtils.getManifest((File)file)) != null) {
                this.processManifest(fd, fileName, mf);
            }
        } else {
            log.warn((Object)("No OSGI-INF/deployment-fragment.xml found in " + file.getPath() + " (must exist, must have exact name)"));
        }
        return fd;
    }

    protected void processManifest(FragmentDescriptor fd, String fileName, Manifest mf) {
        Attributes attrs = mf.getMainAttributes();
        String id = attrs.getValue("Bundle-SymbolicName");
        if (id != null) {
            String requiredBy;
            int p = id.indexOf(59);
            if (p > -1) {
                id = id.substring(0, p);
            }
            this.jar2Id.put(fileName, id);
            fd.name = id;
            if (fd.requires != null && !fd.requires.isEmpty()) {
                throw new Error("You must not use <require> tags for OSGi bundles - use Require-Bundle manifest header instead. Bundle: " + fileName);
            }
            String requires = attrs.getValue("Nuxeo-Require");
            if (requires == null) {
                requires = attrs.getValue("Require-Bundle");
            }
            if (requires != null) {
                String[] ids = StringUtils.split((String)requires, (char)',', (boolean)true);
                fd.requires = new ArrayList<String>(ids.length);
                for (int i = 0; i < ids.length; ++i) {
                    String rid = ids[i];
                    p = rid.indexOf(59);
                    if (p > -1) {
                        ids[i] = rid.substring(0, p);
                    }
                    fd.requires.add(ids[i]);
                }
            }
            if ((requiredBy = attrs.getValue("Nuxeo-RequiredBy")) != null) {
                String[] ids = StringUtils.split((String)requiredBy, (char)',', (boolean)true);
                for (int i = 0; i < ids.length; ++i) {
                    String rid = ids[i];
                    p = rid.indexOf(59);
                    if (p <= -1) continue;
                    ids[i] = rid.substring(0, p);
                }
                fd.requiredBy = ids;
            }
        } else {
            this.jar2Id.put(fileName, fd.name);
        }
    }

    protected ContainerDescriptor getContainer(File directory) throws Exception {
        ContainerDescriptor cd = null;
        File file = new File(directory.getAbsolutePath() + '/' + CONTAINER_FILE);
        if (file.isFile() && (cd = (ContainerDescriptor)this.xmap.load(file.toURL())) != null) {
            cd.directory = directory;
            if (cd.name == null) {
                cd.name = directory.getName();
            }
        }
        return cd;
    }

    public static String getRelativeChildPath(String parent, String child) {
        Path childPath;
        Path parentPath;
        if (parent.indexOf(92) > -1) {
            parent = parent.replace('\\', '/');
        }
        if (child.indexOf(92) > -1) {
            child = child.replace('\\', '/');
        }
        if ((parentPath = new Path(parent)).isPrefixOf(childPath = new Path(child))) {
            return childPath.removeFirstSegments(parentPath.segmentCount()).makeRelative().toString();
        }
        return null;
    }

    public static void main(String[] args) {
        File root = args.length > 0 ? new File(args[0]) : new File(".");
        System.out.println("Preprocessing: " + root);
        DeploymentPreprocessor processor = new DeploymentPreprocessor(root);
        try {
            processor.init();
            processor.predeploy();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Done.");
    }
}

