/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment.preprocessor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.TextTemplate;
import org.nuxeo.runtime.deployment.preprocessor.ConfigurationGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerConfigurator {
    protected static final Log log = LogFactory.getLog(ServerConfigurator.class);
    protected ConfigurationGenerator generator;

    public ServerConfigurator(ConfigurationGenerator configurationGenerator) {
        this.generator = configurationGenerator;
    }

    abstract boolean isConfigured();

    protected void addDirectories(File[] filesToAdd, List<File> inputDirectories) {
        if (filesToAdd != null) {
            for (File in : filesToAdd) {
                inputDirectories.add(in);
            }
        }
    }

    protected void parseAndCopy(Properties config) throws FileNotFoundException, IOException {
        TextTemplate templateParser = new TextTemplate(config);
        File outputDirectory = this.getOutputDirectory();
        ArrayList<File> inputDirectories = new ArrayList<File>();
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return !"nuxeo.defaults".equals(name);
            }
        };
        for (File includedTemplate : this.generator.getIncludedTemplates()) {
            this.addDirectories(includedTemplate.listFiles(filter), inputDirectories);
        }
        for (File in : inputDirectories) {
            templateParser.processDirectory(in, new File(outputDirectory, in.getName()));
        }
    }

    protected abstract File getOutputDirectory();
}

