/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment.preprocessor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.runtime.deployment.preprocessor.DeploymentPreprocessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PackZip {
    private static Log log = LogFactory.getLog(PackZip.class);
    public static final String ORDER_PREPROCESSING = "preprocessing";
    public static final String ORDER_PACKAGING = "packaging";
    protected File nuxeoEar;
    protected File deployerJar;
    protected File deployDir;
    protected File jbossLib;
    protected File dsFile;
    protected File target;

    public PackZip(File nuxeoEar, File target) {
        if (!nuxeoEar.isDirectory()) {
            throw new IllegalArgumentException("Invalid build - no exploded nuxeo.ear found at " + nuxeoEar.getAbsolutePath());
        }
        if (!target.isDirectory()) {
            throw new IllegalArgumentException("Invalid configuration - no target directory found at " + nuxeoEar.getAbsolutePath());
        }
        this.nuxeoEar = nuxeoEar;
        this.target = target;
        this.deployDir = nuxeoEar.getParentFile();
        this.jbossLib = new File(this.deployDir.getParentFile(), "lib");
        this.dsFile = new File(this.deployDir, "nuxeo-ds.xml");
        File deployers = new File(this.deployDir.getParentFile(), "deployers");
        String[] names = deployers.list();
        if (names == null) {
            throw new IllegalArgumentException("Invalid nuxeo.ear location - no nuxeo jboss deployer JAR found in deployers directory");
        }
        for (String name : names) {
            if (!name.startsWith("nuxeo-jboss-deployer") || !name.endsWith(".jar")) continue;
            this.deployerJar = new File(deployers, name);
        }
        if (this.deployerJar == null) {
            throw new IllegalArgumentException("Invalid build - no nuxeo jboss deployer JAR found in deployers directory");
        }
    }

    protected void executePreprocessing() throws ConfigurationException {
        new ConfigurationGenerator().run();
        this.runPreprocessor();
    }

    protected void executePackaging() throws IOException, SAXException, ParserConfigurationException {
        this.moveNonEjbsToLib(this.nuxeoEar);
        this.replaceStructureFile();
        this.moveJarsFromJbossLib();
        FileUtils.moveFile((File)this.deployerJar, (File)new File(this.nuxeoEar, "lib" + File.separator + this.deployerJar.getName()));
        ZipUtils.zip((File[])this.nuxeoEar.listFiles(), (File)new File(this.target, "nuxeo.ear"));
        FileUtils.copyFileToDirectory((File)this.dsFile, (File)this.target);
    }

    public void execute(String order) throws ConfigurationException, IOException, ParserConfigurationException, SAXException {
        if (ORDER_PREPROCESSING.equals(order) || null == order) {
            this.executePreprocessing();
        }
        if (ORDER_PACKAGING.equals(order) || null == order) {
            this.executePackaging();
        }
        if (!ORDER_PREPROCESSING.equals(order) && null != order && !ORDER_PACKAGING.equals(order)) {
            PackZip.fail("Order param should be preprocessing or packaging");
        }
    }

    protected void runPreprocessor() {
        DeploymentPreprocessor.main(new String[]{this.nuxeoEar.getAbsolutePath()});
    }

    protected void replaceStructureFile() {
        File oldf = new File(this.nuxeoEar, "META-INF" + File.separator + "nuxeo-structure.xml");
        File newf = new File(this.nuxeoEar, "META-INF" + File.separator + "nuxeo-structure-zip.xml");
        newf.renameTo(oldf);
    }

    protected void moveJarsFromJbossLib() {
    }

    protected void moveNonEjbsToLib(File wd) throws ParserConfigurationException, SAXException, IOException {
        File file = new File(wd, "META-INF" + File.separator + "application.xml");
        if (!file.isFile()) {
            log.error((Object)"You should run this tool from a preprocessed nuxeo.ear folder");
        }
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        FileInputStream in = new FileInputStream(file);
        Document doc = docBuilder.parse(in);
        Element root = doc.getDocumentElement();
        NodeList list = root.getElementsByTagName("module");
        ArrayList<String> paths = new ArrayList<String>();
        for (int i = 0; i < list.getLength(); ++i) {
            Element el = (Element)list.item(i);
            for (Node n = el.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (n.getNodeType() != 1) continue;
                Element mtype = (Element)n;
                String type = n.getNodeName().toLowerCase();
                if ("web".equals(type)) continue;
                String path = mtype.getTextContent().trim();
                paths.add(path);
            }
        }
        File ejbs = new File(wd, "tmp-ejbs");
        ejbs.mkdirs();
        for (String path : paths) {
            log.info((Object)("Move EAR module " + path + " to " + ejbs.getName()));
            File f = new File(wd, path);
            if (f.getName().endsWith(".txt")) continue;
            FileUtils.moveToDirectory((File)f, (File)ejbs, (boolean)false);
        }
        File lib = new File(wd, "lib");
        File[] files = new File(wd, "bundles").listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.getName().endsWith(".txt")) continue;
                log.info((Object)("Move POJO bundle " + f.getName() + " to lib"));
                FileUtils.moveToDirectory((File)f, (File)lib, (boolean)false);
            }
        }
        File bundles = new File(wd, "bundles");
        files = ejbs.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.getName().endsWith(".txt")) continue;
                log.info((Object)("Move back EAR module " + f.getName() + " to bundles"));
                FileUtils.moveToDirectory((File)f, (File)bundles, (boolean)false);
            }
        }
    }

    protected static void fail(String message) {
        log.error((Object)message);
        System.exit(1);
    }

    public static void main(String[] args) throws IOException, ConfigurationException, ParserConfigurationException, SAXException {
        String v;
        File ear;
        if (args.length < 2) {
            PackZip.fail("Usage: PackZip nuxeo_ear_directory target_directory [order]");
        }
        if (!(ear = new File(v = args[0])).isDirectory()) {
            PackZip.fail("Invalid build - no exploded nuxeo.ear found at " + ear.getAbsolutePath());
        }
        v = args[1];
        File target = new File(v);
        ear = ear.getCanonicalFile();
        if ((target = target.getCanonicalFile()).exists()) {
            FileUtils.deleteDirectory((File)target);
        }
        target.mkdirs();
        if (!target.isDirectory()) {
            PackZip.fail("Invalid target directory: " + v + ". Not a directory or directory could not be created");
        }
        log.info((Object)("Packing nuxeo.ear at " + ear.getAbsolutePath() + " into " + target.getAbsolutePath()));
        PackZip pack = new PackZip(ear, target);
        if (args.length >= 3) {
            pack.execute(args[2]);
        } else {
            pack.execute(null);
        }
    }
}

