/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment.preprocessor.install.commands;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.common.utils.PathFilter;
import org.nuxeo.runtime.deployment.preprocessor.install.Command;
import org.nuxeo.runtime.deployment.preprocessor.install.CommandContext;

public class CopyCommand
implements Command {
    protected final Path src;
    protected final Path dst;
    protected final PathFilter filter;

    public CopyCommand(Path src, Path dst) {
        this(src, dst, null);
    }

    public CopyCommand(Path src, Path dst, PathFilter filter) {
        this.src = src;
        this.dst = dst;
        this.filter = filter;
    }

    @Override
    public void exec(CommandContext ctx) throws IOException {
        File baseDir = ctx.getBaseDir();
        File srcFile = new File(baseDir, ctx.expandVars(this.src.toString()));
        File dstFile = new File(baseDir, ctx.expandVars(this.dst.toString()));
        if (!srcFile.exists()) {
            throw new FileNotFoundException("Could not find the file " + srcFile.getAbsolutePath() + " to copy.");
        }
        dstFile = new File(dstFile.getCanonicalPath());
        srcFile = new File(srcFile.getCanonicalPath());
        if (!dstFile.exists()) {
            if (this.dst.hasTrailingSeparator()) {
                dstFile.mkdirs();
            } else {
                File parent = dstFile.getParentFile();
                if (!parent.isDirectory()) {
                    parent.mkdirs();
                }
            }
        }
        if (this.filter == null) {
            if (srcFile.isDirectory() && this.src.hasTrailingSeparator()) {
                FileUtils.copy((File[])srcFile.listFiles(), (File)dstFile);
            } else {
                FileUtils.copy((File)srcFile, (File)dstFile);
            }
        } else if (srcFile.isDirectory() && this.src.hasTrailingSeparator()) {
            FileUtils.copyTree((File)srcFile, (File)dstFile, (PathFilter)this.filter);
        } else {
            FileUtils.copy((File)srcFile, (File)dstFile);
        }
    }

    public String toString() {
        return "copy " + this.src.toString() + " > " + this.dst.toString();
    }

    @Override
    public String toString(CommandContext ctx) {
        return "copy " + ctx.expandVars(this.src.toString()) + " > " + ctx.expandVars(this.dst.toString());
    }
}

