/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jetty;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JettyResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected static final int BUFFER_SIZE = 10240;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String context = req.getContextPath();
        String resourceVPath = req.getRequestURI().substring(context.length());
        String resourcePath = this.getServletContext().getRealPath(resourceVPath);
        if (!this.checkAccess(resourcePath)) {
            resp.sendError(403);
            return;
        }
        File resource = new File(resourcePath);
        if (resource.exists()) {
            if (resource.isDirectory()) {
                resp.sendRedirect("index.jsp");
                return;
            }
            this.sendFile(resource, resp);
        } else {
            resp.sendError(404);
        }
    }

    protected boolean checkAccess(String resourcePath) {
        return true;
    }

    protected void sendFile(File resource, HttpServletResponse resp) throws ServletException, IOException {
        FileInputStream in = null;
        try {
            int read;
            ServletOutputStream out = resp.getOutputStream();
            in = new FileInputStream(resource);
            byte[] buffer = new byte[10240];
            while ((read = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, read);
                out.flush();
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (resp != null) {
                resp.flushBuffer();
            }
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }
}

