/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jtajca;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.geronimo.connector.outbound.AbstractConnectionManager;
import org.apache.geronimo.connector.outbound.GenericConnectionManager;
import org.apache.geronimo.connector.outbound.SubjectSource;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PartitionedPool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.XATransactions;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTracker;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTrackingCoordinator;
import org.apache.geronimo.transaction.GeronimoUserTransaction;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class NuxeoContainer {
    private static RecoverableTransactionManager transactionManager;
    private static UserTransaction userTransaction;
    private static ConnectionManagerWrapper connectionManager;

    private NuxeoContainer() {
    }

    public static void install() throws NamingException {
        NuxeoContainer.initTransactionManager(new TransactionManagerConfiguration());
        NuxeoContainer.initConnectionManager(new ConnectionManagerConfiguration());
        InitialContext context = new InitialContext();
        context.rebind("java:comp/TransactionManager", (Object)NuxeoContainer.getTransactionManager());
        context.rebind("java:comp/UserTransaction", (Object)NuxeoContainer.getUserTransaction());
        context.rebind("java:comp/NuxeoConnectionManager", (Object)NuxeoContainer.getConnectionManager());
    }

    public static TransactionManager getTransactionManager() {
        return transactionManager;
    }

    public static UserTransaction getUserTransaction() throws NamingException {
        if (transactionManager == null) {
            NuxeoContainer.initTransactionManager();
        }
        return userTransaction;
    }

    public static ConnectionManager getConnectionManager() {
        return connectionManager;
    }

    protected static void initTransactionManager() throws NamingException {
        TransactionHelper.lookupTransactionManager();
    }

    public static synchronized void initTransactionManager(TransactionManagerConfiguration config) {
        if (transactionManager == null) {
            transactionManager = NuxeoContainer.createTransactionManager(config);
            userTransaction = NuxeoContainer.createUserTransaction((TransactionManager)transactionManager);
        }
    }

    public static synchronized void initConnectionManager(ConnectionManagerConfiguration config) throws NamingException {
        if (transactionManager == null) {
            NuxeoContainer.initTransactionManager();
        }
        if (connectionManager == null) {
            AbstractConnectionManager cm = NuxeoContainer.createConnectionManager(transactionManager, config);
            connectionManager = new ConnectionManagerWrapper(cm, config);
        }
    }

    public static synchronized void resetConnectionManager() throws Exception {
        ConnectionManagerWrapper cm = connectionManager;
        if (cm == null) {
            return;
        }
        cm.reset();
    }

    protected static RecoverableTransactionManager createTransactionManager(TransactionManagerConfiguration config) {
        try {
            return new TransactionManagerImpl(config.transactionTimeoutSeconds);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    protected static UserTransaction createUserTransaction(TransactionManager transactionManager) {
        return new GeronimoUserTransaction(transactionManager);
    }

    protected static AbstractConnectionManager createConnectionManager(RecoverableTransactionManager transactionManager, ConnectionManagerConfiguration config) {
        XATransactions transactionSupport = new XATransactions(config.useTransactionCaching, config.useThreadCaching);
        PartitionedPool poolingSupport = new PartitionedPool(config.maxPoolSize, config.minPoolSize, config.blockingTimeoutMillis, config.idleTimeoutMinutes, config.matchOne, config.matchAll, config.selectOneNoMatch, config.partitionByConnectionRequestInfo, config.partitionBySubject);
        final Subject subject = new Subject();
        SubjectSource subjectSource = new SubjectSource(){

            public Subject getSubject() {
                return subject;
            }
        };
        ConnectionTrackingCoordinator connectionTracker = new ConnectionTrackingCoordinator();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return new GenericConnectionManager((TransactionSupport)transactionSupport, (PoolingSupport)poolingSupport, subjectSource, (ConnectionTracker)connectionTracker, transactionManager, config.name, classLoader);
    }

    public static void initTransactionManagement() throws NamingException {
        NuxeoContainer.initTransactionManager(new TransactionManagerConfiguration());
        NuxeoContainer.initConnectionManager(new ConnectionManagerConfiguration());
        InitialContext initialContext = new InitialContext();
        initialContext.rebind("java:comp/TransactionManager", (Object)NuxeoContainer.getTransactionManager());
        initialContext.rebind("java:comp/UserTransaction", (Object)NuxeoContainer.getUserTransaction());
        initialContext.rebind("java:comp/NuxeoConnectionManager", (Object)NuxeoContainer.getConnectionManager());
    }

    public static class ConnectionManagerConfiguration {
        public String name = "NuxeoConnectionManager";
        public boolean useTransactionCaching = true;
        public boolean useThreadCaching = true;
        public boolean matchOne = true;
        public boolean matchAll = true;
        public boolean selectOneNoMatch = false;
        public boolean partitionByConnectionRequestInfo = false;
        public boolean partitionBySubject = true;
        public int maxPoolSize = 20;
        public int minPoolSize = 0;
        public int blockingTimeoutMillis = 100;
        public int idleTimeoutMinutes = 0;

        public void setName(String name) {
            this.name = name;
        }

        public void setUseTransactionCaching(boolean useTransactionCaching) {
            this.useTransactionCaching = useTransactionCaching;
        }

        public void setUseThreadCaching(boolean useThreadCaching) {
            this.useThreadCaching = useThreadCaching;
        }

        public void setMatchOne(boolean matchOne) {
            this.matchOne = matchOne;
        }

        public void setMatchAll(boolean matchAll) {
            this.matchAll = matchAll;
        }

        public void setSelectOneNoMatch(boolean selectOneNoMatch) {
            this.selectOneNoMatch = selectOneNoMatch;
        }

        public void setPartitionByConnectionRequestInfo(boolean partitionByConnectionRequestInfo) {
            this.partitionByConnectionRequestInfo = partitionByConnectionRequestInfo;
        }

        public void setPartitionBySubject(boolean partitionBySubject) {
            this.partitionBySubject = partitionBySubject;
        }

        public void setMaxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
        }

        public void setMinPoolSize(int minPoolSize) {
            this.minPoolSize = minPoolSize;
        }

        public void setBlockingTimeoutMillis(int blockingTimeoutMillis) {
            this.blockingTimeoutMillis = blockingTimeoutMillis;
        }

        public void setIdleTimeoutMinutes(int idleTimeoutMinutes) {
            this.idleTimeoutMinutes = idleTimeoutMinutes;
        }
    }

    public static class ConnectionManagerWrapper
    implements ConnectionManager {
        private static final long serialVersionUID = 1L;
        protected AbstractConnectionManager cm;
        protected final ConnectionManagerConfiguration config;

        public ConnectionManagerWrapper(AbstractConnectionManager cm, ConnectionManagerConfiguration config) {
            this.cm = cm;
            this.config = config;
        }

        public Object allocateConnection(ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
            return this.cm.allocateConnection(managedConnectionFactory, connectionRequestInfo);
        }

        public void reset() throws Exception {
            this.cm.doStop();
            this.cm = NuxeoContainer.createConnectionManager(transactionManager, this.config);
        }
    }

    public static class TransactionManagerConfiguration {
        public int transactionTimeoutSeconds = 600;

        public void setTransactionTimeoutSeconds(int transactionTimeoutSeconds) {
            this.transactionTimeoutSeconds = transactionTimeoutSeconds;
        }
    }
}

