/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jtajca;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.outbound.AbstractConnectionManager;
import org.apache.geronimo.connector.outbound.GenericConnectionManager;
import org.apache.geronimo.connector.outbound.SubjectSource;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PartitionedPool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.XATransactions;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTracker;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTrackingCoordinator;
import org.apache.geronimo.transaction.manager.NamedXAResourceFactory;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.apache.xbean.naming.reference.SimpleReference;
import org.nuxeo.runtime.api.InitialContextAccessor;
import org.nuxeo.runtime.jtajca.NamingContext;
import org.nuxeo.runtime.jtajca.NamingContextFacade;
import org.nuxeo.runtime.jtajca.NamingContextFactory;
import org.nuxeo.runtime.jtajca.NuxeoConnectionManagerConfiguration;
import org.nuxeo.runtime.metrics.MetricsService;

public class NuxeoContainer {
    protected static final Log log = LogFactory.getLog(NuxeoContainer.class);
    public static final String JNDI_TRANSACTION_MANAGER = "java:comp/TransactionManager";
    public static final String JNDI_USER_TRANSACTION = "java:comp/UserTransaction";
    public static final String JNDI_NUXEO_CONNECTION_MANAGER_PREFIX = "java:comp/NuxeoConnectionManager/";
    private static TransactionManagerWrapper transactionManager;
    private final UserTransaction userTransaction = new UserTransactionImpl();
    private static Map<String, ConnectionManagerWrapper> connectionManagers;
    private static InstallContext installContext;
    private static Context parentContext;
    private static Map<String, Object> parentEnvironment;
    protected static Context rootContext;
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected final Counter rollbackCount = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"transactions", "rollbacks"}));
    protected final Counter concurrentCount = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"transactions", "concurrents", "count"}));
    protected final Counter concurrentMaxCount = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"transactions", "concurrents", "max"}));
    protected final Timer transactionTimer = this.registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"transactions", "duration"}));
    protected final ConcurrentHashMap<Transaction, Timer.Context> timers = new ConcurrentHashMap();
    protected static NuxeoContainer instance;

    private NuxeoContainer() {
    }

    public static synchronized void install() throws NamingException {
        if (installContext != null) {
            throw new RuntimeException("Nuxeo container already installed");
        }
        NuxeoContainer.install(null);
    }

    public static synchronized void install(TransactionManagerConfiguration txconfig) throws NamingException {
        NuxeoContainer.installNaming();
        NuxeoContainer.installTransactionManager(txconfig);
    }

    protected static void installTransactionManager(TransactionManagerConfiguration config) throws NamingException {
        transactionManager = NuxeoContainer.lookupTransactionManager();
        if (transactionManager == null) {
            if (config == null) {
                config = new TransactionManagerConfiguration();
            }
            NuxeoContainer.initTransactionManager(config);
            NuxeoContainer.addDeepBinding(rootContext, new CompositeName(JNDI_TRANSACTION_MANAGER), NuxeoContainer.getTransactionManagerReference());
            NuxeoContainer.addDeepBinding(rootContext, new CompositeName(JNDI_USER_TRANSACTION), NuxeoContainer.getUserTransactionReference());
        }
    }

    public static synchronized ConnectionManagerWrapper installConnectionManager(String repositoryName, NuxeoConnectionManagerConfiguration config) {
        ConnectionManagerWrapper cm = connectionManagers.get(repositoryName);
        if (cm != null) {
            return cm;
        }
        if (config == null) {
            config = new NuxeoConnectionManagerConfiguration();
            config.setName(config.name + "/" + repositoryName);
        }
        cm = NuxeoContainer.initConnectionManager(repositoryName, config);
        if (rootContext != null) {
            String jndiName = JNDI_NUXEO_CONNECTION_MANAGER_PREFIX + repositoryName;
            try {
                NuxeoContainer.addDeepBinding(rootContext, new CompositeName(jndiName), NuxeoContainer.getConnectionManagerReference(repositoryName));
            }
            catch (NamingException e) {
                log.error((Object)("Cannot bind in JNDI connection manager " + config.name + " to name " + jndiName));
            }
        }
        return cm;
    }

    public static synchronized boolean isInstalled() {
        return installContext != null;
    }

    public static synchronized InstallContext getInstallContext() {
        return installContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void uninstall() throws NamingException {
        if (installContext == null) {
            throw new RuntimeException("Nuxeo container not installed");
        }
        try {
            try {
                NuxeoContainer.removeBinding(JNDI_TRANSACTION_MANAGER);
            }
            catch (NamingException e) {
                log.error((Object)e, (Throwable)e);
            }
            try {
                NuxeoContainer.removeBinding(JNDI_USER_TRANSACTION);
            }
            catch (NamingException e) {
                log.error((Object)e, (Throwable)e);
            }
            for (String repositoryName : connectionManagers.keySet()) {
                String jndiName = JNDI_NUXEO_CONNECTION_MANAGER_PREFIX + repositoryName;
                try {
                    NuxeoContainer.removeBinding(jndiName);
                }
                catch (NamingException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
        finally {
            NuxeoContainer.uninstallNaming();
            transactionManager = null;
            connectionManagers.clear();
        }
    }

    public static synchronized void installNaming() throws NamingException {
        installContext = new InstallContext();
        log.trace((Object)"Installing nuxeo container", (Throwable)installContext);
        NuxeoContainer.setupRootContext();
        NuxeoContainer.setAsInitialContext();
    }

    public static synchronized void uninstallNaming() {
        log.trace((Object)"Uninstalling nuxeo container", (Throwable)installContext);
        installContext = null;
        parentContext = null;
        rootContext = null;
        NuxeoContainer.revertSetAsInitialContext();
    }

    protected static void setupRootContext() throws NamingException {
        parentContext = InitialContextAccessor.getInitialContext();
        if (parentContext != null) {
            if (InitialContextAccessor.isWritable((Context)parentContext)) {
                rootContext = parentContext;
                return;
            }
            rootContext = new NamingContextFacade(parentContext);
            log.warn((Object)"Chaining naming spaces, can break your application server");
            return;
        }
        rootContext = new NamingContext();
    }

    public static Context getRootContext() {
        return rootContext;
    }

    protected static void setAsInitialContext() {
        String key = "java.naming.factory.initial";
        parentEnvironment.put(key, System.getProperty(key));
        key = "java.naming.factory.url.pkgs";
        parentEnvironment.put(key, System.getProperty(key));
        System.setProperty("java.naming.factory.initial", NamingContextFactory.class.getName());
        System.setProperty("java.naming.factory.url.pkgs", "org.nuxeo.runtime.jtajca");
    }

    protected static void revertSetAsInitialContext() {
        Iterator<Map.Entry<String, Object>> iterator = parentEnvironment.entrySet().iterator();
        Properties props = System.getProperties();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            iterator.remove();
            String key = entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) {
                props.remove(key);
                continue;
            }
            props.setProperty(key, value);
        }
    }

    public static void addDeepBinding(String name, Object obj) throws NamingException {
        NuxeoContainer.addDeepBinding(rootContext, new CompositeName(name), obj);
    }

    protected static void addDeepBinding(Context dir, CompositeName comp, Object obj) throws NamingException {
        Context subdir;
        Name name = comp.getPrefix(1);
        if (comp.size() == 1) {
            NuxeoContainer.addBinding(dir, name, obj);
            return;
        }
        try {
            subdir = (Context)dir.lookup(name);
        }
        catch (NamingException e) {
            subdir = dir.createSubcontext(name);
        }
        NuxeoContainer.addDeepBinding(subdir, (CompositeName)comp.getSuffix(1), obj);
    }

    protected static void addBinding(Context dir, Name name, Object obj) throws NamingException {
        try {
            dir.rebind(name, obj);
        }
        catch (NamingException e) {
            dir.bind(name, obj);
        }
    }

    protected static void removeBinding(String name) throws NamingException {
        rootContext.unbind(name);
    }

    protected static <T> T resolveBinding(String name) throws NamingException {
        InitialContext ctx = new InitialContext();
        try {
            return (T)ctx.lookup("java:comp/" + name);
        }
        catch (NamingException compe) {
            try {
                return (T)ctx.lookup("java:comp/env/" + name);
            }
            catch (NamingException enve) {
                return (T)ctx.lookup(name);
            }
        }
    }

    public static TransactionManager getTransactionManager() {
        return transactionManager;
    }

    protected static Reference getTransactionManagerReference() {
        return new SimpleReference(){
            private static final long serialVersionUID = 1L;

            public Object getContent() throws NamingException {
                return NuxeoContainer.getTransactionManager();
            }
        };
    }

    public UserTransaction getUserTransaction() throws NamingException {
        return this.userTransaction;
    }

    protected static Reference getUserTransactionReference() {
        return new SimpleReference(){
            private static final long serialVersionUID = 1L;

            public Object getContent() throws NamingException {
                return instance.getUserTransaction();
            }
        };
    }

    public static ConnectionManager getConnectionManager(String repositoryName) {
        return connectionManagers.get(repositoryName);
    }

    protected static void setConnectionManager(String repositoryName, ConnectionManagerWrapper cm) {
        if (connectionManagers.containsKey(repositoryName)) {
            log.error((Object)("Repository " + repositoryName + " already set up"), (Throwable)new Exception());
        }
        connectionManagers.put(repositoryName, cm);
    }

    protected static Reference getConnectionManagerReference(final String repositoryName) {
        return new SimpleReference(){
            private static final long serialVersionUID = 1L;

            public Object getContent() throws NamingException {
                return NuxeoContainer.getConnectionManager(repositoryName);
            }
        };
    }

    public static synchronized void initTransactionManager(TransactionManagerConfiguration config) throws NamingException {
        TransactionManager tm = NuxeoContainer.createTransactionManager(config);
        transactionManager = new TransactionManagerWrapper(tm);
    }

    protected static TransactionManagerWrapper lookupTransactionManager() {
        TransactionManager tm;
        try {
            tm = (TransactionManager)NuxeoContainer.resolveBinding("TransactionManager");
        }
        catch (NamingException e) {
            return null;
        }
        if (tm instanceof TransactionManagerWrapper) {
            return (TransactionManagerWrapper)tm;
        }
        return new TransactionManagerWrapper(tm);
    }

    public static synchronized ConnectionManagerWrapper initConnectionManager(String repositoryName, NuxeoConnectionManagerConfiguration config) {
        GenericConnectionManager cm = NuxeoContainer.createConnectionManager(config);
        ConnectionManagerWrapper cmw = new ConnectionManagerWrapper((AbstractConnectionManager)cm, config);
        NuxeoContainer.setConnectionManager(repositoryName, cmw);
        return cmw;
    }

    public static synchronized void resetConnectionManager() throws Exception {
        for (ConnectionManagerWrapper cm : connectionManagers.values()) {
            cm.reset();
        }
    }

    protected static ConnectionManagerWrapper lookupConnectionManager(String repositoryName) {
        ConnectionManager cm;
        try {
            String jndiName = JNDI_NUXEO_CONNECTION_MANAGER_PREFIX + repositoryName;
            Object o = NuxeoContainer.resolveBinding(jndiName);
            cm = (ConnectionManager)o;
        }
        catch (NamingException e) {
            return null;
        }
        if (cm instanceof ConnectionManagerWrapper) {
            return (ConnectionManagerWrapper)cm;
        }
        log.warn((Object)"Connection manager not a wrapper, check your configuration");
        return null;
    }

    protected static TransactionManager createTransactionManager(TransactionManagerConfiguration config) {
        try {
            return new TransactionManagerImpl(config.transactionTimeoutSeconds);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    protected static GenericConnectionManager createConnectionManager(NuxeoConnectionManagerConfiguration config) {
        XATransactions transactionSupport = new XATransactions(config.useTransactionCaching, config.useThreadCaching);
        PartitionedPool poolingSupport = new PartitionedPool(config.maxPoolSize, config.minPoolSize, config.blockingTimeoutMillis, config.idleTimeoutMinutes, config.matchOne, config.matchAll, config.selectOneNoMatch, config.partitionByConnectionRequestInfo, config.partitionBySubject);
        final Subject subject = new Subject();
        SubjectSource subjectSource = new SubjectSource(){

            public Subject getSubject() {
                return subject;
            }
        };
        ConnectionTrackingCoordinator connectionTracker = new ConnectionTrackingCoordinator();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return new GenericConnectionManager((TransactionSupport)transactionSupport, (PoolingSupport)poolingSupport, subjectSource, (ConnectionTracker)connectionTracker, (RecoverableTransactionManager)transactionManager, config.name, classLoader);
    }

    static {
        connectionManagers = new ConcurrentHashMap<String, ConnectionManagerWrapper>(8, 0.75f, 2);
        parentEnvironment = new HashMap<String, Object>();
        instance = new NuxeoContainer();
    }

    public static class ConnectionManagerWrapper
    implements ConnectionManager {
        private static final long serialVersionUID = 1L;
        protected AbstractConnectionManager cm;
        protected final NuxeoConnectionManagerConfiguration config;

        public ConnectionManagerWrapper(AbstractConnectionManager cm, NuxeoConnectionManagerConfiguration config) {
            this.cm = cm;
            this.config = config;
        }

        public Object allocateConnection(ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
            return this.cm.allocateConnection(managedConnectionFactory, connectionRequestInfo);
        }

        public void reset() throws Exception {
            this.cm.doStop();
            this.cm = NuxeoContainer.createConnectionManager(this.config);
        }
    }

    public static class TransactionManagerWrapper
    implements RecoverableTransactionManager {
        protected TransactionManager tm;

        public TransactionManagerWrapper(TransactionManager tm) {
            this.tm = tm;
        }

        public Transaction suspend() throws SystemException {
            return this.tm.suspend();
        }

        public void setTransactionTimeout(int seconds) throws SystemException {
            this.tm.setTransactionTimeout(seconds);
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.tm.setRollbackOnly();
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            this.tm.rollback();
        }

        public void resume(Transaction tobj) throws IllegalStateException, InvalidTransactionException, SystemException {
            this.tm.resume(tobj);
        }

        public Transaction getTransaction() throws SystemException {
            return this.tm.getTransaction();
        }

        public int getStatus() throws SystemException {
            return this.tm.getStatus();
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            this.tm.commit();
        }

        public void begin() throws SystemException {
            try {
                this.tm.begin();
            }
            catch (NotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public void recoveryError(Exception e) {
            throw new UnsupportedOperationException();
        }

        public void registerNamedXAResourceFactory(NamedXAResourceFactory factory) {
            if (RecoverableTransactionManager.class.isAssignableFrom(this.tm.getClass())) {
                ((RecoverableTransactionManager)this.tm).registerNamedXAResourceFactory(factory);
            }
        }

        public void unregisterNamedXAResourceFactory(String factory) {
            if (RecoverableTransactionManager.class.isAssignableFrom(this.tm.getClass())) {
                ((RecoverableTransactionManager)this.tm).unregisterNamedXAResourceFactory(factory);
            }
        }
    }

    public static class TransactionManagerConfiguration {
        public int transactionTimeoutSeconds = 600;

        public void setTransactionTimeoutSeconds(int transactionTimeoutSeconds) {
            this.transactionTimeoutSeconds = transactionTimeoutSeconds;
        }
    }

    public class UserTransactionImpl
    implements UserTransaction {
        protected boolean checked;

        protected void check() throws SystemException {
            if (transactionManager != null) {
                return;
            }
            if (!this.checked) {
                this.checked = true;
                transactionManager = NuxeoContainer.lookupTransactionManager();
            }
            if (transactionManager == null) {
                throw new SystemException("No active transaction manager");
            }
        }

        public int getStatus() throws SystemException {
            this.check();
            return transactionManager.getStatus();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.check();
            transactionManager.setRollbackOnly();
        }

        public void setTransactionTimeout(int seconds) throws SystemException {
            this.check();
            transactionManager.setTransactionTimeout(seconds);
        }

        public void begin() throws NotSupportedException, SystemException {
            this.check();
            transactionManager.begin();
            NuxeoContainer.this.timers.put(transactionManager.getTransaction(), NuxeoContainer.this.transactionTimer.time());
            NuxeoContainer.this.concurrentCount.inc();
            if (NuxeoContainer.this.concurrentCount.getCount() > NuxeoContainer.this.concurrentMaxCount.getCount()) {
                NuxeoContainer.this.concurrentMaxCount.inc();
            }
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            this.check();
            Timer.Context timerContext = NuxeoContainer.this.timers.remove(transactionManager.getTransaction());
            transactionManager.commit();
            if (timerContext != null) {
                timerContext.stop();
            }
            NuxeoContainer.this.concurrentCount.dec();
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            this.check();
            Timer.Context timerContext = NuxeoContainer.this.timers.remove(transactionManager.getTransaction());
            transactionManager.rollback();
            NuxeoContainer.this.concurrentCount.dec();
            if (timerContext != null) {
                timerContext.stop();
            }
            NuxeoContainer.this.rollbackCount.inc();
        }
    }

    public static class InstallContext
    extends Throwable {
        private static final long serialVersionUID = 1L;
        public final String threadName = Thread.currentThread().getName();

        InstallContext() {
            super("Container installation context (" + Thread.currentThread().getName() + ")");
        }
    }
}

