/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.kv;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.runtime.kv.KeyValueStoreProvider;

public abstract class AbstractKeyValueStoreProvider
implements KeyValueStoreProvider {
    protected static final ThreadLocal<CharsetDecoder> UTF_8_DECODERS = ThreadLocal.withInitial(() -> StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT));

    protected static String bytesToString(byte[] bytes) throws CharacterCodingException {
        return bytes == null ? null : UTF_8_DECODERS.get().decode(ByteBuffer.wrap(bytes)).toString();
    }

    protected static byte[] stringToBytes(String string) {
        return string == null ? null : string.getBytes(StandardCharsets.UTF_8);
    }

    protected static Long bytesToLong(byte[] bytes) throws NumberFormatException {
        if (bytes == null) {
            return null;
        }
        if (bytes.length > 20) {
            throw new NumberFormatException("For input string of length " + bytes.length);
        }
        return Long.valueOf(new String(bytes, StandardCharsets.UTF_8));
    }

    protected static byte[] longToBytes(Long value) {
        return value == null ? null : value.toString().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public void put(String key, byte[] value) {
        this.put(key, value, 0L);
    }

    @Override
    public void put(String key, String value) {
        this.put(key, AbstractKeyValueStoreProvider.stringToBytes(value), 0L);
    }

    @Override
    public void put(String key, String value, long ttl) {
        this.put(key, AbstractKeyValueStoreProvider.stringToBytes(value), ttl);
    }

    @Override
    public void put(String key, Long value) {
        this.put(key, AbstractKeyValueStoreProvider.longToBytes(value), 0L);
    }

    @Override
    public void put(String key, Long value, long ttl) {
        this.put(key, AbstractKeyValueStoreProvider.longToBytes(value), ttl);
    }

    @Override
    public String getString(String key) {
        byte[] bytes = this.get(key);
        try {
            return AbstractKeyValueStoreProvider.bytesToString(bytes);
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException("Value is not a String for key: " + key);
        }
    }

    @Override
    public Long getLong(String key) throws NumberFormatException {
        byte[] bytes = this.get(key);
        return AbstractKeyValueStoreProvider.bytesToLong(bytes);
    }

    @Override
    public Map<String, byte[]> get(Collection<String> keys) {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>(keys.size());
        for (String key : keys) {
            byte[] value = this.get(key);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    @Override
    public Map<String, String> getStrings(Collection<String> keys) {
        HashMap<String, String> map = new HashMap<String, String>(keys.size());
        for (String key : keys) {
            String value = this.getString(key);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    @Override
    public Map<String, Long> getLongs(Collection<String> keys) throws NumberFormatException {
        HashMap<String, Long> map = new HashMap<String, Long>(keys.size());
        for (String key : keys) {
            Long value = this.getLong(key);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    @Override
    public boolean compareAndSet(String key, byte[] expected, byte[] value) {
        return this.compareAndSet(key, expected, value, 0L);
    }

    @Override
    public boolean compareAndSet(String key, String expected, String value) {
        return this.compareAndSet(key, expected, value, 0L);
    }

    @Override
    public boolean compareAndSet(String key, String expected, String value, long ttl) {
        return this.compareAndSet(key, AbstractKeyValueStoreProvider.stringToBytes(expected), AbstractKeyValueStoreProvider.stringToBytes(value), ttl);
    }

    @Override
    public long addAndGet(String key, long delta) throws NumberFormatException {
        long base;
        long result;
        String newValue;
        String value;
        while (!this.compareAndSet(key, value, newValue = Long.toString(result = (base = (value = this.getString(key)) == null ? 0L : Long.parseLong(value)) + delta))) {
        }
        return result;
    }
}

