/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.kv;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.runtime.kv.KeyValueService;
import org.nuxeo.runtime.kv.KeyValueStore;
import org.nuxeo.runtime.kv.KeyValueStoreDescriptor;
import org.nuxeo.runtime.kv.KeyValueStoreProvider;
import org.nuxeo.runtime.kv.MemKeyValueStore;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class KeyValueServiceImpl
extends DefaultComponent
implements KeyValueService {
    public static final String XP_CONFIG = "configuration";
    public static final String DEFAULT_STORE_ID = "default";
    public static final int APPLICATION_STARTED_ORDER = -500;
    protected Map<String, KeyValueStoreProvider> providers = new ConcurrentHashMap<String, KeyValueStoreProvider>();
    protected KeyValueStore defaultStore = new MemKeyValueStore();

    public int getApplicationStartedOrder() {
        return -500;
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.providers.values().forEach(KeyValueStoreProvider::close);
        super.stop(context);
    }

    @Override
    public synchronized KeyValueStore getKeyValueStore(String name) {
        KeyValueStoreProvider provider = this.providers.get(name);
        if (provider == null) {
            KeyValueStoreDescriptor descriptor = (KeyValueStoreDescriptor)this.getDescriptor(XP_CONFIG, name);
            if (descriptor == null && (descriptor = (KeyValueStoreDescriptor)this.getDescriptor(XP_CONFIG, DEFAULT_STORE_ID)) == null) {
                return this.defaultStore;
            }
            try {
                provider = descriptor.klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                provider.initialize(descriptor);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            this.providers.put(name, provider);
        }
        return provider;
    }
}

