/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.kv;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.runtime.kv.KeyValueService;
import org.nuxeo.runtime.kv.KeyValueStore;
import org.nuxeo.runtime.kv.KeyValueStoreDescriptor;
import org.nuxeo.runtime.kv.KeyValueStoreProvider;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class KeyValueServiceImpl
extends DefaultComponent
implements KeyValueService {
    public static final String XP_CONFIG = "configuration";
    public static final String DEFAULT_STORE_ID = "default";
    public static final int APPLICATION_STARTED_ORDER = -500;
    protected Map<String, KeyValueStoreProvider> providers = new ConcurrentHashMap<String, KeyValueStoreProvider>();

    public int getApplicationStartedOrder() {
        return -500;
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.providers.values().forEach(KeyValueStoreProvider::close);
        this.providers.clear();
        super.stop(context);
    }

    @Override
    public synchronized KeyValueStore getKeyValueStore(String name) {
        KeyValueStoreProvider provider = this.providers.get(name);
        if (provider == null) {
            KeyValueStoreDescriptor desc;
            Optional optDesc = this.getRegistryContribution(XP_CONFIG, name);
            if (optDesc.isEmpty()) {
                optDesc = this.getRegistryContribution(XP_CONFIG, DEFAULT_STORE_ID);
                if (optDesc.isEmpty()) {
                    throw new RuntimeException("Missing configuration for default key/value store");
                }
                desc = new KeyValueStoreDescriptor((KeyValueStoreDescriptor)optDesc.get());
                desc.name = name;
                desc.namespace = name;
            } else {
                desc = (KeyValueStoreDescriptor)optDesc.get();
            }
            try {
                provider = desc.klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                provider.initialize(desc);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            this.providers.put(name, provider);
        }
        return provider;
    }
}

