/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.launcher;

import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;

public class RMILoaderHandlerBug {
    private static final Map pathToURLsCache = new WeakHashMap(5);

    private static String urlsToPath(URL[] urls) {
        if (urls.length == 0) {
            return null;
        }
        if (urls.length == 1) {
            return urls[0].toExternalForm();
        }
        StringBuilder path = new StringBuilder(urls[0].toExternalForm());
        for (int i = 1; i < urls.length; ++i) {
            path.append(' ');
            path.append(urls[i].toExternalForm());
        }
        return path.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL[] pathToURLs(String path) throws MalformedURLException {
        Map map = pathToURLsCache;
        synchronized (map) {
            Object[] v = (Object[])pathToURLsCache.get(path);
            if (v != null) {
                return (URL[])v[0];
            }
        }
        StringTokenizer st = new StringTokenizer(path);
        URL[] urls = new URL[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            urls[i] = new URL(st.nextToken());
            ++i;
        }
        Map map2 = pathToURLsCache;
        synchronized (map2) {
            pathToURLsCache.put(path, new Object[]{urls, new SoftReference<String>(path)});
        }
        return urls;
    }

    public static void main(String[] args) {
        String codebase = null;
        try {
            System.out.println(new URL("file:///C:/Program Files/MyApp").toExternalForm());
            String path = "file:///C:/Program Files/MyApp";
            codebase = RMILoaderHandlerBug.urlsToPath(new URL[]{new URL(path)});
            System.out.println("urlsToPath succeded: [" + codebase + "]");
        }
        catch (MalformedURLException e) {
            System.out.println("urlsToPath failed: " + e.getMessage());
        }
        try {
            URL[] urls = RMILoaderHandlerBug.pathToURLs(codebase);
            if (urls.length == 1) {
                System.out.println("pathToURLs succeded: [" + urls[0] + "]");
            }
        }
        catch (MalformedURLException e) {
            System.out.println("pathToURLs failed: " + e.getMessage());
        }
    }
}

