/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.management.metrics;

import org.javasimon.Callback;
import org.javasimon.SimonManager;
import org.nuxeo.runtime.management.metrics.MetricEnabler;
import org.nuxeo.runtime.management.metrics.MetricRegisterer;
import org.nuxeo.runtime.management.metrics.MetricRegisteringCallback;
import org.nuxeo.runtime.management.metrics.MetricSerializer;
import org.nuxeo.runtime.management.metrics.MetricSerializerMXBean;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.osgi.framework.BundleContext;

public class MetricComponent
extends DefaultComponent {
    protected final MetricSerializer serializer = new MetricSerializer();
    protected final MetricEnabler enabler = new MetricEnabler();
    protected final MetricRegisterer register = new MetricRegisterer();
    protected final MetricRegisteringCallback registeringCB = new MetricRegisteringCallback();

    public <T> T getAdapter(Class<T> adapter) {
        if (MetricSerializerMXBean.class.isAssignableFrom(adapter)) {
            return adapter.cast(this.serializer);
        }
        return (T)super.getAdapter(adapter);
    }

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.doStart();
    }

    public void deactivate(ComponentContext context) throws Exception {
        super.deactivate(context);
    }

    public void start(BundleContext context) {
        this.doStart();
    }

    public void stop(BundleContext context) {
        this.doStop();
    }

    protected void doStart() {
        this.enabler.setSerializer(this.serializer);
        SimonManager.enable();
        SimonManager.callback().addCallback((Callback)this.registeringCB);
        this.register.registerMXBean(this.enabler);
        this.register.registerMXBean(this.serializer);
    }

    protected void doStop() {
        SimonManager.disable();
        SimonManager.callback().removeCallback((Callback)this.registeringCB);
        this.register.unregisterMXBean(this.enabler);
        this.register.unregisterMXBean(this.serializer);
    }
}

