/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.management.metrics;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.util.Calendar;
import org.javasimon.Sample;
import org.javasimon.SimonManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.management.metrics.MetricSerializerMXBean;

public class MetricSerializer
implements MetricSerializerMXBean {
    protected File file;
    protected ObjectOutputStream outputStream;
    protected int count;
    protected long lastUsage;

    public void toStream(Sample ... samples) throws IOException {
        if (this.outputStream == null) {
            return;
        }
        for (Sample sample : samples) {
            this.outputStream.writeObject(sample);
        }
        ++this.count;
        this.lastUsage = Calendar.getInstance().getTimeInMillis();
    }

    @Override
    public String getOutputLocation() {
        if (this.file == null) {
            return "/dev/null";
        }
        return this.file.getAbsolutePath();
    }

    public File getOutputFile() {
        return this.file;
    }

    @Override
    public void resetOutput(String path) throws IOException {
        this.file = new File(path);
        this.resetOutput();
    }

    @Override
    public void resetOutput() throws IOException {
        if (this.file == null) {
            this.createTempFile();
        }
        this.closeOutput();
        FileWriter writer = new FileWriter(this.file);
        this.outputStream = new XStream().createObjectOutputStream((Writer)writer);
        for (String name : SimonManager.simonNames()) {
            SimonManager.getSimon((String)name).reset();
        }
    }

    public void flushOuput() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void closeOutput() throws IOException {
        if (this.outputStream == null) {
            return;
        }
        this.outputStream.close();
        this.outputStream = null;
    }

    private void createTempFile() throws IOException {
        this.file = Framework.createTempFile((String)"nx-samples-", (String)".xml");
        Framework.trackFile((File)this.file, (Object)this.file);
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public long getLastUsage() {
        return this.lastUsage;
    }
}

