/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.management.metrics;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.management.ObjectNameFactory;
import org.nuxeo.runtime.management.ResourcePublisher;

public class MetricRegister {
    protected static final Log log = LogFactory.getLog(MetricRegister.class);
    protected final HashMap<String, String> cnames = new HashMap();

    protected String canonicalName(String name, String type) {
        return ObjectNameFactory.formatMetricQualifiedName(name, type);
    }

    public void registerMXBean(Object mbean, String name, Class<?> itf, String type) {
        ResourcePublisher srv = (ResourcePublisher)Framework.getService(ResourcePublisher.class);
        String cname = this.canonicalName(name, type);
        srv.registerResource(name, cname, itf, mbean);
        this.cnames.put(name, cname);
    }

    public void unregisterMXBean(Object mbean) {
        this.unregisterMXBean(mbean.getClass().getSimpleName());
    }

    public void unregisterMXBean(String name) {
        ResourcePublisher srv = (ResourcePublisher)Framework.getService(ResourcePublisher.class);
        if (srv == null) {
            return;
        }
        String cname = this.cnames.remove(name);
        if (cname != null) {
            srv.unregisterResource(name, cname);
        }
    }

    public void unregisterAll() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.cnames.keySet());
        for (String name : names) {
            this.unregisterMXBean(name);
        }
    }
}

